/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.js;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataObject;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class JsDoc
extends NativeObject {
    private FlattenerContext flattenerContext;
    private List<JsDataObject> jsDataObjects;
    private NativeArray jsInfo;

    public JsDoc(FlattenerContext flattenerContext) {
        this.flattenerContext = flattenerContext;
        this.defineFunctionProperties(new String[]{"getDataObject"}, JsDoc.class, 1);
        this.defineProperty("dataObjects", JsDoc.class, 1);
        this.defineProperty("metadata", JsDoc.class, 1);
        this.defineProperty("info", JsDoc.class, 1);
    }

    public JsDataObject getDataObject(String name) throws Exception {
        this.ensureDataObjectsInited();
        for (JsDataObject jsDataObject : this.jsDataObjects) {
            if (!jsDataObject.get("name").equals(name)) continue;
            return jsDataObject;
        }
        throw new Exception("TypeError: Invalid argument type.");
    }

    public NativeArray getDataObjects() {
        this.ensureDataObjectsInited();
        return new NativeArray(this.jsDataObjects.toArray());
    }

    public String getMetadata() throws IOException {
        PdfReader reader = this.flattenerContext.getReader();
        String metadata = new String(reader.getMetadata(), "UTF-8");
        return metadata;
    }

    public NativeArray getInfo() {
        if (this.jsInfo == null) {
            this.jsInfo = new NativeArray(new Object[0]);
            PdfReader reader = this.flattenerContext.getReader();
            if (reader != null) {
                for (Map.Entry<String, String> infoEntry : reader.getInfo().entrySet()) {
                    this.jsInfo.put(infoEntry.getKey(), (Scriptable)this.jsInfo, (Object)infoEntry.getValue());
                }
            }
        }
        return this.jsInfo;
    }

    private void ensureDataObjectsInited() {
        PdfDictionary catalog;
        PdfDictionary names;
        if (this.jsDataObjects != null) {
            return;
        }
        this.jsDataObjects = new ArrayList<JsDataObject>();
        PdfReader reader = this.flattenerContext.getReader();
        if (reader != null && (names = (catalog = reader.getCatalog()).getAsDict(PdfName.NAMES)) != null) {
            PdfObject embeddedFiles = names.get(PdfName.EMBEDDEDFILES);
            if ((embeddedFiles = PdfReader.getPdfObject(embeddedFiles)) != null && embeddedFiles.isDictionary()) {
                PdfDictionary embeddedFilesNameTreeRoot = (PdfDictionary)embeddedFiles;
                this.processEFNameTree(embeddedFilesNameTreeRoot);
            }
        }
    }

    private void processEFNameTree(PdfDictionary embeddedFilesNameTreeRoot) {
        PdfObject kids = embeddedFilesNameTreeRoot.get(PdfName.KIDS);
        if ((kids = PdfReader.getPdfObject(kids)) != null && kids.isArray()) {
            for (PdfObject kidObj : (PdfArray)kids) {
                PdfObject kidDict = PdfReader.getPdfObject(kidObj);
                if (kidDict == null || !kidDict.isDictionary()) continue;
                this.processEFNameTree((PdfDictionary)kidDict);
            }
        } else {
            this.processEFNameTreeLeafNode(embeddedFilesNameTreeRoot);
        }
    }

    private void processEFNameTreeLeafNode(PdfDictionary kidDict) {
        PdfObject namesArray = kidDict.get(PdfName.NAMES);
        if ((namesArray = PdfReader.getPdfObject(namesArray)) != null && namesArray.isArray()) {
            PdfArray fileSpecs = (PdfArray)namesArray;
            int i = 0;
            while (i < fileSpecs.size()) {
                PdfString fileName = fileSpecs.getAsString(i++);
                PdfObject fileSpec = fileSpecs.getPdfObject(i++);
                if ((fileSpec = PdfReader.getPdfObject(fileSpec)) == null || !fileSpec.isDictionary()) continue;
                this.jsDataObjects.add(new JsDataObject(fileName.toUnicodeString(), (PdfDictionary)fileSpec));
            }
        }
    }
}

