/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.processors;

import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.munit.mock.MockModule;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class OutboundEndpointMessageProcessor extends AbstractMockMessageProcessor {
    public static final String MESSAGE_PROCESSOR_NAME = "outbound-endpoint";

    protected Object address;

    protected Object returnPayload;
    protected Object exception;
    protected Object thenApplyTransformer;
    protected Object returnInvocationProperties;
    protected Object returnInboundProperties;
    protected Object returnSessionProperties;
    protected Object returnOutboundProperties;
    protected Object assertions;


    public void initialise() throws InitialisationException {
        super.initialise();
        if (assertions instanceof List) {
            for (MessageProcessor messageProcessor : ((List<MessageProcessor>) assertions)) {
                if (messageProcessor instanceof Initialisable) {
                    ((Initialisable) messageProcessor).initialise();
                }
            }
        }
    }

    /**
     * Sets address
     *
     * @param value Value to set
     */
    public void setAddress(Object value) {
        this.address = value;
    }

    /**
     * Sets returnInboundProperties
     *
     * @param value Value to set
     */
    public void setReturnInboundProperties(Object value) {
        this.returnInboundProperties = value;
    }

    /**
     * Sets returnInvocationProperties
     *
     * @param value Value to set
     */
    public void setReturnInvocationProperties(Object value) {
        this.returnInvocationProperties = value;
    }

    /**
     * Sets returnOutboundProperties
     *
     * @param value Value to set
     */
    public void setReturnOutboundProperties(Object value) {
        this.returnOutboundProperties = value;
    }

    /**
     * Sets returnSessionProperties
     *
     * @param value Value to set
     */
    public void setReturnSessionProperties(Object value) {
        this.returnSessionProperties = value;
    }

    /**
     * Sets assertions
     *
     * @param value Value to set
     */
    public void setAssertions(Object value) {
        this.assertions = value;
    }

    /**
     * Sets thenApplyTransformer
     *
     * @param value Value to set
     */
    public void setThenApplyTransformer(Object value) {
        this.thenApplyTransformer = value;
    }

    /**
     * Sets exception
     *
     * @param value Value to set
     */
    public void setException(Object value) {
        this.exception = value;
    }

    /**
     * Sets returnPayload
     *
     * @param value Value to set
     */
    public void setReturnPayload(Object value) {
        this.returnPayload = value;
    }

    /**
     * Invokes the MessageProcessor.
     * <p/>
     *
     * @param muleEvent MuleEvent to be processed
     * @param module    the MockModule
     * @throws Exception
     */
    protected void doProcess(MuleEvent muleEvent, MockModule module) throws Exception {
        MuleMessage mulemessage = muleEvent.getMessage();

        module.outboundEndpoint(
                (String) address,
                evaluate(mulemessage, returnPayload),
                (DefaultMuleException) exception,
                thenApplyTransformer,
                transformProperties(returnInvocationProperties, muleEvent),
                transformProperties(returnInboundProperties, muleEvent),
                transformProperties(returnSessionProperties, muleEvent),
                transformProperties(returnOutboundProperties, muleEvent),
                transformAssertions(assertions, muleEvent)
        );

    }

    private Map<String, Object> transformProperties(Object properties, MuleEvent muleEvent) throws TransformerMessagingException {
        Map<String, Object> transformedProperties = new HashMap<String, Object>();
        if (properties != null) {
            Map<String, Object> prop = (Map<String, Object>) properties;
            for (String key : prop.keySet()) {
                transformedProperties.put(key, evaluate(muleEvent.getMessage(), prop.get(key)));
            }
        }

        return transformedProperties;
    }

    @Override
    protected String getProcessor() {
        return MESSAGE_PROCESSOR_NAME;
    }

}
