/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.processors;

import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.mock.MockModule;

import java.util.List;


public class SpyMessageProcessor extends AbstractMockMessageProcessor {
    public static final String MESSAGE_PROCESSOR_NAME = "spy";

    protected Object messageProcessor;
    protected Object withAttributes;
    protected Object assertionsBeforeCall;
    protected Object assertionsAfterCall;

    public void initialise() throws InitialisationException {
        super.initialise();
        if (assertionsBeforeCall instanceof List) {
            for (MessageProcessor messageProcessor : ((List<MessageProcessor>) assertionsBeforeCall)) {
                if (messageProcessor instanceof Initialisable) {
                    ((Initialisable) messageProcessor).initialise();
                }
            }
        }
        if (assertionsAfterCall instanceof List) {
            for (MessageProcessor messageProcessor : ((List<MessageProcessor>) assertionsAfterCall)) {
                if (messageProcessor instanceof Initialisable) {
                    ((Initialisable) messageProcessor).initialise();
                }
            }
        }
    }

    /**
     * Sets messageProcessor
     *
     * @param value Value to set
     */
    public void setMessageProcessor(Object value) {
        this.messageProcessor = value;
    }

    /**
     * Sets withAttributes
     *
     * @param value Value to set
     */
    public void setWithAttributes(Object value) {
        this.withAttributes = value;
    }

    /**
     * Sets assertionsBeforeCall
     *
     * @param value Value to set
     */
    public void setAssertionsBeforeCall(Object value) {
        this.assertionsBeforeCall = value;
    }


    /**
     * Sets assertionsAfterCall
     *
     * @param value Value to set
     */
    public void setAssertionsAfterCall(Object value) {
        this.assertionsAfterCall = value;
    }

    /**
     * Invokes the MessageProcessor.
     * <p/>
     *
     * @param muleEvent MuleEvent to be processed
     * @param module    the MockModule
     * @throws Exception
     */
    protected void doProcess(MuleEvent muleEvent, MockModule module) throws Exception {

        module.spy(
                (String) messageProcessor,
                transformAttributes(withAttributes, muleEvent),
                (List<MessageProcessor>)assertionsBeforeCall,
                (List<MessageProcessor>)assertionsAfterCall
        );
    }

    @Override
    protected String getProcessor() {
        return MESSAGE_PROCESSOR_NAME;
    }

}
