/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import com.newrelic.api.agent.TraceLambda;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TraceLambdaVisitor
implements ClassMatchVisitorFactory {
    private static final String TRACE_LAMBDA_DESC = Type.getDescriptor(TraceLambda.class);
    private static final Pattern LAMBDA_METHOD_NAME_PATTERN = Pattern.compile("^\\$?(lambda|anonfun)\\$(?<name>.*)");
    private static final String PATTERN_PROPERTY_NAME = "pattern";
    private static final String INCLUDE_NONSTATIC_PROPERTY_NAME = "includeNonstatic";

    @Override
    public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, final InstrumentationContext context) {
        return new ClassVisitor(589824, cv){
            private boolean isTraceLambdaClass;
            private boolean includeNonstatic;
            private Pattern traceLambdaPattern;
            {
                super(x0, x1);
                this.isTraceLambdaClass = false;
                this.includeNonstatic = false;
                this.traceLambdaPattern = LAMBDA_METHOD_NAME_PATTERN;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
                if (TRACE_LAMBDA_DESC.equals(descriptor)) {
                    this.isTraceLambdaClass = true;
                    av = new AnnotationVisitor(589824, av){

                        @Override
                        public void visit(String name, Object value) {
                            super.visit(name, value);
                            if (TraceLambdaVisitor.PATTERN_PROPERTY_NAME.equals(name) && value instanceof String && value != "") {
                                traceLambdaPattern = Pattern.compile(String.valueOf(value));
                            }
                            if (TraceLambdaVisitor.INCLUDE_NONSTATIC_PROPERTY_NAME.equals(name) && value instanceof Boolean) {
                                includeNonstatic = (Boolean)value;
                            }
                        }
                    };
                }
                return av;
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                if (this.isTraceLambdaClass) {
                    Method method;
                    Matcher matcher;
                    boolean isStatic;
                    boolean bl = isStatic = (access & 8) == 8;
                    if ((this.includeNonstatic || isStatic) && (matcher = this.traceLambdaPattern.matcher((method = new Method(name, descriptor)).getName())).matches()) {
                        String match = this.containsNameGroup(matcher) ? matcher.group("name") : matcher.group();
                        String metricName = match.replace("$", ".");
                        context.addTrace(method, TraceDetailsBuilder.newBuilder().setMetricName(metricName).setInstrumentationType(InstrumentationType.BuiltIn).setInstrumentationSourceName(TraceLambdaVisitor.class.getName()).setTransactionName(TransactionNamePriority.FRAMEWORK_LOW, false, "Custom", metricName).build());
                    }
                }
                return mv;
            }

            private boolean containsNameGroup(Matcher matcher) {
                try {
                    return !matcher.group("name").isEmpty();
                }
                catch (IllegalArgumentException ex) {
                    return false;
                }
            }
        };
    }
}

