/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.Agent;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.trace.TransactionGuidFactory;
import com.newrelic.agent.tracing.DistributedTracePayloadImpl;
import com.newrelic.agent.tracing.DistributedTracePayloadParser;
import com.newrelic.agent.tracing.W3CTraceParent;
import com.newrelic.agent.tracing.W3CTraceState;
import com.newrelic.api.agent.DistributedTracePayload;
import com.newrelic.api.agent.NewRelic;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class SpanProxy {
    private volatile long timestamp;
    private volatile long transportDurationInMillis;
    private final AtomicReference<String> traceId = new AtomicReference<Object>(null);
    private final AtomicReference<DistributedTracePayloadImpl> inboundPayloadData = new AtomicReference<Object>(null);
    private final AtomicReference<DistributedTracePayloadImpl> outboundPayloadData = new AtomicReference<Object>(null);
    private final AtomicReference<W3CTraceParent> initiatingW3CTraceParent = new AtomicReference<Object>(null);
    private final AtomicReference<W3CTraceState> initiatingW3CTraceState = new AtomicReference<Object>(null);

    public String getOrCreateTraceId() {
        String id = this.traceId.get();
        if (id == null) {
            String newGuid = TransactionGuidFactory.generate16CharGuid() + TransactionGuidFactory.generate16CharGuid();
            this.traceId.compareAndSet(null, newGuid);
        }
        return this.traceId.get();
    }

    public String getTraceId() {
        return this.traceId.get();
    }

    public DistributedTracePayload createDistributedTracePayload(Float priority, String guid, String txnId) {
        try {
            String traceId = this.getOrCreateTraceId();
            DistributedTracePayloadImpl payload = DistributedTracePayloadImpl.createDistributedTracePayload(traceId, guid, txnId, priority.floatValue());
            if (payload == null) {
                return null;
            }
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, "Created distributed trace payload: {0} for transactionId: {1}", payload, txnId);
            }
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/CreatePayload/Success");
            this.outboundPayloadData.compareAndSet(null, payload);
            return payload;
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Unable to create distributed trace payload");
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/CreatePayload/Exception");
            return null;
        }
    }

    public boolean acceptDistributedTracePayload(String payload) {
        try {
            DistributedTracePayloadParser parser = new DistributedTracePayloadParser(NewRelic.getAgent().getMetricAggregator(), ServiceFactory.getDistributedTraceService(), Agent.LOG);
            DistributedTracePayloadImpl parsedPayload = parser.parse(this.outboundPayloadData.get(), payload);
            return parsedPayload != null && this.acceptDistributedTracePayloadImpl(parsedPayload);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Unable to accept distributed trace payload: {0}", payload);
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Exception");
            return false;
        }
    }

    public boolean acceptDistributedTracePayload(DistributedTracePayload payload) {
        try {
            if (this.outboundPayloadData.get() != null) {
                Agent.LOG.log(Level.WARNING, "Error: createDistributedTracePayload was called before acceptDistributedTracePayload. Ignoring Call");
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Ignored/CreateBeforeAccept");
                return false;
            }
            if (payload instanceof DistributedTracePayloadImpl) {
                return this.acceptDistributedTracePayloadImpl((DistributedTracePayloadImpl)payload);
            }
            Agent.LOG.log(Level.FINEST, "Unable to accept distributed trace payload. Incorrect type: {0}", payload.getClass().getName());
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Unable to accept distributed trace payload: {0}", payload);
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Exception");
        }
        return false;
    }

    private boolean acceptDistributedTracePayloadImpl(DistributedTracePayloadImpl payload) {
        if (this.inboundPayloadData.compareAndSet(null, payload)) {
            this.traceId.set(payload.traceId);
            this.transportDurationInMillis = this.timestamp - payload.timestamp;
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Success");
            return true;
        }
        NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Ignored/Multiple");
        return false;
    }

    public DistributedTracePayloadImpl getInboundDistributedTracePayload() {
        return this.inboundPayloadData.get();
    }

    public DistributedTracePayloadImpl getOutboundDistributedTracePayload() {
        return this.outboundPayloadData.get();
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTransportDurationInMillis() {
        return this.transportDurationInMillis;
    }

    public W3CTraceParent getInitiatingW3CTraceParent() {
        return this.initiatingW3CTraceParent.get();
    }

    public W3CTraceState getInitiatingW3CTraceState() {
        return this.initiatingW3CTraceState.get();
    }

    public void setInitiatingW3CTraceParent(W3CTraceParent w3CTraceParent) {
        if (this.initiatingW3CTraceParent.compareAndSet(null, w3CTraceParent)) {
            this.traceId.set(w3CTraceParent.getTraceId());
        }
    }

    public void setInitiatingW3CTraceState(W3CTraceState w3CTraceState) {
        this.initiatingW3CTraceState.compareAndSet(null, w3CTraceState);
    }
}

