/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.CriticalHeaderParamsAware;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypterMulti;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWERecipient;
import com.nimbusds.jose.UnprotectedHeader;
import com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import com.nimbusds.jose.crypto.impl.ECDH;
import com.nimbusds.jose.crypto.impl.ECDHCryptoProvider;
import com.nimbusds.jose.crypto.utils.ECChecks;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDHDecrypterMulti
extends ECDHCryptoProvider
implements JWEDecrypterMulti,
CriticalHeaderParamsAware {
    public static final Set<Curve> SUPPORTED_ELLIPTIC_CURVES;
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final List<Pair<UnprotectedHeader, ECKey>> recipients;

    public ECDHDecrypterMulti(List<Pair<UnprotectedHeader, ECKey>> recipients) throws JOSEException {
        this(recipients, null);
    }

    public ECDHDecrypterMulti(List<Pair<UnprotectedHeader, ECKey>> recipients, Set<String> defCritHeaders) throws JOSEException {
        super(recipients.get(0).getRight().getCurve());
        this.recipients = recipients;
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return SUPPORTED_ELLIPTIC_CURVES;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public byte[] decrypt(JWEHeader header, List<JWERecipient> recipients, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        this.critPolicy.ensureHeaderPasses(header);
        ECKey ephemeralKey = (ECKey)header.getEphemeralPublicKey();
        if (ephemeralKey == null) {
            throw new JOSEException("Missing ephemeral public EC key \"epk\" JWE header parameter");
        }
        ArrayList<Pair<UnprotectedHeader, SecretKey>> sharedKeys = new ArrayList<Pair<UnprotectedHeader, SecretKey>>();
        for (Pair<UnprotectedHeader, ECKey> recipient : this.recipients) {
            if (!ECChecks.isPointOnCurve(ephemeralKey.toECPublicKey(), recipient.getRight().toECPrivateKey())) {
                throw new JOSEException("Invalid ephemeral public EC key: Point(s) not on the expected curve");
            }
            SecretKey Z = ECDH.deriveSharedSecret(ephemeralKey.toECPublicKey(), recipient.getRight().toECPrivateKey(), this.getJCAContext().getKeyEncryptionProvider());
            sharedKeys.add(Pair.of(recipient.getLeft(), Z));
        }
        return this.decryptMulti(header, sharedKeys, recipients, iv, cipherText, authTag);
    }

    static {
        LinkedHashSet<Curve> curves = new LinkedHashSet<Curve>();
        curves.add(Curve.P_256);
        curves.add(Curve.P_384);
        curves.add(Curve.P_521);
        SUPPORTED_ELLIPTIC_CURVES = Collections.unmodifiableSet(curves);
    }
}

