/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.logging.runtime;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.runtime.Features;
import oracle.jdbc.logging.runtime.TraceController;

@DisableTrace
public class TraceControllerImpl
implements TraceController {
    private static final Features features;
    private RuntimeException reSuspended = new IllegalStateException("trace controller is currently suspended");
    public static long feature;
    private static long backup;
    private static int suspends;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trace(boolean enable, Feature ... features) {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 != suspends) {
                throw this.reSuspended;
            }
            long fMask = 0L;
            for (Feature f : features) {
                fMask |= f.bitVector();
            }
            feature = enable ? feature | fMask : feature & (fMask ^ 0xFFFFFFFFFFFFFFFFL);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getEnabledFeatures() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 != suspends) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new Feature[0];
            }
            ArrayList<Feature> enabledFeatures = new ArrayList<Feature>();
            if (feature == Feature.ALL.bitVector()) {
                enabledFeatures.add(Feature.ALL);
            } else {
                for (Feature f : this.getSupportedFeatures()) {
                    if (Feature.ALL == f) continue;
                    if (0L == (feature & f.bitVector())) continue;
                    enabledFeatures.add(f);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return enabledFeatures.toArray(new Feature[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getSupportedFeatures() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            ArrayList<Feature> supportedFeatures = new ArrayList<Feature>();
            for (Feature feature : Feature.values()) {
                supportedFeatures.add(feature);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return supportedFeatures.toArray(new Feature[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 == suspends++) {
                backup = feature;
                feature = 0L;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            int s = --suspends;
            if (0 == s) {
                feature = backup;
            } else if (s < 0) {
                suspends = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTracing(Feature ... supportedFeatures) {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 != suspends) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            boolean isTracing = true;
            for (Feature feature : supportedFeatures) {
                if (0L != (TraceControllerImpl.feature & feature.bitVector())) continue;
                isTracing = false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return isTracing;
        }
    }

    static {
        String trace;
        features = new Features("oracle.jdbc.logging.annotations.Supports");
        feature = Feature.ALL_UCP.bitVector();
        String prop = System.getProperty("oracle.jdbc.Trace");
        if (null != prop && ("true".equals(trace = prop.trim().toLowerCase()) || "on".equals(trace))) {
            feature |= Feature.ALL_JDBC.bitVector();
        }
        String PREFIX = "clio.feature";
        String configFile = System.getProperty("java.util.logging.config.file");
        if (null != configFile) {
            Properties props = new Properties();
            InputStream inputStream = TraceControllerImpl.class.getClassLoader().getResourceAsStream(configFile);
            if (null == inputStream) {
                try {
                    inputStream = new FileInputStream(configFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (null != inputStream) {
                try {
                    props.load(inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            long selectedFeature = 0L;
            for (Feature f : Feature.values()) {
                String key = "clio.feature." + f.toString().toLowerCase();
                String value = props.getProperty(key);
                if (null == value) continue;
                String v = value.toLowerCase().trim();
                if ("on".equals(v) || "true".equals(v)) {
                    selectedFeature |= f.bitVector();
                    continue;
                }
                if (!"off".equals(v) && !"false".equals(v)) continue;
                selectedFeature &= f.bitVector() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (0L != selectedFeature) {
                feature = selectedFeature;
            }
        }
        backup = 0L;
        suspends = 0;
    }
}

