/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.convert;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Genson;
import com.owlike.genson.Wrapper;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class CircularClassReferenceConverterFactory
extends ChainedFactory {
    private final ThreadLocal<Map<Type, CircularConverter<?>>> _circularConverters = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Converter<?> create(Type type, Genson genson) {
        Map<Type, CircularConverter<?>> map = this._circularConverters.get();
        if (map == null) {
            map = new HashMap();
            this._circularConverters.set(map);
        }
        if (this._circularConverters.get().containsKey(type)) {
            return this._circularConverters.get().get(type);
        }
        try {
            CircularConverter circularConverter = new CircularConverter();
            try {
                this._circularConverters.get().put(type, circularConverter);
                Converter<?> converter = this.next().create(type, genson);
                circularConverter.setDelegateConverter(converter);
                Converter<?> converter2 = converter;
                circularConverter.initLatch.countDown();
                return converter2;
            }
            catch (Throwable throwable) {
                circularConverter.initLatch.countDown();
                throw throwable;
            }
        }
        finally {
            this._circularConverters.get().remove(type);
        }
    }

    @Override
    protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
        throw new UnsupportedOperationException();
    }

    private static final class CircularConverter<T>
    extends Wrapper<Converter<T>>
    implements Converter<T> {
        private CountDownLatch initLatch = new CountDownLatch(1);

        protected CircularConverter() {
        }

        @Override
        public void serialize(T obj, ObjectWriter writer, Context ctx) throws Exception {
            if (this.wrapped == null) {
                this.initLatch.await();
            }
            ((Converter)this.wrapped).serialize(obj, writer, ctx);
        }

        @Override
        public T deserialize(ObjectReader reader, Context ctx) throws Exception {
            if (this.wrapped == null) {
                this.initLatch.await();
            }
            return ((Converter)this.wrapped).deserialize(reader, ctx);
        }

        void setDelegateConverter(Converter<T> delegate) {
            this.decorate(delegate);
        }
    }
}

