/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import com.owlike.genson.stream.JsonStreamException;
import com.owlike.genson.stream.JsonType;
import com.owlike.genson.stream.ObjectWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;

public class GensonJsonGenerator
implements JsonGenerator {
    public static final String SKIP_NULL = "GensonJsonGenerator.skipNull";
    public static final String HTML_SAFE = "GensonJsonGenerator.htmlSafe";
    private final ObjectWriter writer;
    private final Deque<JsonType> _ctx = new ArrayDeque<JsonType>();

    public GensonJsonGenerator(ObjectWriter writer) {
        this.writer = writer;
    }

    public JsonGenerator writeStartObject() {
        try {
            this.writer.beginObject();
            this._ctx.push(JsonType.OBJECT);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator writeStartObject(String name) {
        try {
            this.writer.writeName(name).beginObject();
            this._ctx.push(JsonType.OBJECT);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator writeStartArray() {
        try {
            this.writer.beginArray();
            this._ctx.push(JsonType.ARRAY);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator writeStartArray(String name) {
        try {
            this.writer.writeName(name).beginArray();
            this._ctx.push(JsonType.ARRAY);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(String name, JsonValue value) {
        try {
            this.writer.writeName(name);
        }
        catch (JsonStreamException e) {
            throw new JsonException(e.getMessage(), e.getCause());
        }
        return this.write(value);
    }

    public JsonGenerator write(String name, String value) {
        try {
            this.writer.writeName(name).writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(String name, BigInteger value) {
        try {
            this.writer.writeName(name).writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(String name, BigDecimal value) {
        try {
            this.writer.writeName(name).writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(String name, int value) {
        try {
            this.writer.writeName(name).writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(String name, long value) {
        try {
            this.writer.writeName(name).writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(String name, double value) {
        try {
            this.writer.writeName(name).writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(String name, boolean value) {
        try {
            this.writer.writeName(name).writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator writeNull(String name) {
        try {
            this.writer.writeName(name).writeNull();
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator writeEnd() {
        block4: {
            JsonType type = this._ctx.pop();
            try {
                if (JsonType.OBJECT == type) {
                    this.writer.endObject();
                    break block4;
                }
                if (JsonType.ARRAY == type) {
                    this.writer.endArray();
                    break block4;
                }
                throw new JsonGenerationException("Must call writeStartObject or writeStartArray before calling writeEnd.");
            }
            catch (JsonStreamException jse) {
                throw new JsonGenerationException(jse.getMessage(), jse.getCause());
            }
        }
        return this;
    }

    public JsonGenerator write(JsonValue value) {
        JsonValue.ValueType type = value.getValueType();
        if (JsonValue.ValueType.ARRAY == type) {
            this.writeStartArray();
            JsonArray array = (JsonArray)value;
            for (JsonValue elem : array) {
                this.write(elem);
            }
            this.writeEnd();
        } else if (JsonValue.ValueType.OBJECT == type) {
            this.writeStartObject();
            JsonObject object = (JsonObject)value;
            for (Map.Entry entry : object.entrySet()) {
                this.write((String)entry.getKey(), (JsonValue)entry.getValue());
            }
            this.writeEnd();
        } else if (JsonValue.ValueType.FALSE == type) {
            this.write(false);
        } else if (JsonValue.ValueType.TRUE == type) {
            this.write(true);
        } else if (JsonValue.ValueType.NULL == type) {
            this.writeNull();
        } else if (JsonValue.ValueType.STRING == type) {
            this.write(((JsonString)value).getString());
        } else if (JsonValue.ValueType.NUMBER == type) {
            JsonNumber num = (JsonNumber)value;
            if (num.isIntegral()) {
                this.write(num.bigIntegerValueExact());
            } else {
                this.write(num.bigDecimalValue());
            }
        }
        return this;
    }

    public JsonGenerator write(String value) {
        try {
            this.writer.writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(BigDecimal value) {
        try {
            this.writer.writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(BigInteger value) {
        try {
            this.writer.writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(int value) {
        try {
            this.writer.writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(long value) {
        try {
            this.writer.writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(double value) {
        try {
            this.writer.writeValue(value);
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator write(boolean value) {
        try {
            this.writer.writeValue(value);
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public JsonGenerator writeNull() {
        try {
            this.writer.writeNull();
        }
        catch (Exception e) {
            this._wrapAndThrow(e);
        }
        return this;
    }

    public void close() {
        this.flush();
        this.writer.close();
    }

    public void flush() {
        this.writer.flush();
    }

    private void _wrapAndThrow(Exception e) {
        Object newException = null;
        newException = e instanceof JsonStreamException ? new JsonGenerationException(e.getMessage(), (Throwable)e) : new JsonException(e.getMessage(), (Throwable)e);
        throw (JsonException)JsonStreamException.niceTrace(newException);
    }
}

