/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.reporter.plain;

import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.Reporter;
import com.pinterest.ktlint.reporter.plain.internal.Color;
import com.pinterest.ktlint.reporter.plain.internal.ColorKt;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J \u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0005H\u0016J\f\u0010\"\u001a\u00020\u000e*\u00020\u000eH\u0002R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/pinterest/ktlint/reporter/plain/PlainReporter;", "Lcom/pinterest/ktlint/core/Reporter;", "out", "Ljava/io/PrintStream;", "verbose", "", "groupByFile", "shouldColorOutput", "outputColor", "Lcom/pinterest/ktlint/reporter/plain/internal/Color;", "pad", "(Ljava/io/PrintStream;ZZZLcom/pinterest/ktlint/reporter/plain/internal/Color;Z)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/pinterest/ktlint/core/LintError;", "getGroupByFile", "()Z", "getOut", "()Ljava/io/PrintStream;", "getOutputColor", "()Lcom/pinterest/ktlint/reporter/plain/internal/Color;", "getPad", "getShouldColorOutput", "getVerbose", "after", "", "file", "colorFileName", "fileName", "onLintError", "err", "corrected", "colored", "ktlint-reporter-plain"})
public final class PlainReporter
implements Reporter {
    private final ConcurrentHashMap<String, List<LintError>> acc;
    @NotNull
    private final PrintStream out;
    private final boolean verbose;
    private final boolean groupByFile;
    private final boolean shouldColorOutput;
    @NotNull
    private final Color outputColor;
    private final boolean pad;

    public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
        if (!corrected) {
            if (this.groupByFile) {
                ConcurrentMap $this$getOrPut$iv = this.acc;
                boolean $i$f$getOrPut = false;
                Object object = $this$getOrPut$iv.get(file);
                if (object == null) {
                    boolean bl = false;
                    ArrayList arrayList = new ArrayList();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ArrayList default$iv = arrayList;
                    boolean bl4 = false;
                    object = $this$getOrPut$iv.putIfAbsent(file, default$iv);
                    if (object == null) {
                        object = default$iv;
                    }
                }
                ((List)object).add(err);
            } else {
                String string;
                String string2 = "" + err.getCol() + ':';
                StringBuilder stringBuilder = new StringBuilder().append(':');
                PlainReporter plainReporter = this;
                StringBuilder stringBuilder2 = new StringBuilder().append(this.colorFileName(file)).append(this.colored(":")).append(err.getLine());
                PrintStream printStream = this.out;
                boolean bl = false;
                boolean bl5 = false;
                String it = string2;
                boolean bl6 = false;
                if (this.pad) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string3 = "%-4s";
                    Object[] objectArray = new Object[]{it};
                    boolean bl7 = false;
                    String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                    string = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                } else {
                    string = it;
                }
                String string5 = string;
                printStream.println(stringBuilder2.append(plainReporter.colored(stringBuilder.append(string5).toString())).append(' ').append(err.getDetail()).append(this.verbose ? this.colored(" (" + err.getRuleId() + ')') : "").toString());
            }
        }
    }

    public void after(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.groupByFile) {
            List<LintError> list = this.acc.get(file);
            if (list == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"acc[file] ?: return");
            List<LintError> errList = list;
            this.out.println(this.colorFileName(file));
            for (LintError lintError : errList) {
                String string;
                int line = lintError.component1();
                int col = lintError.component2();
                String ruleId = lintError.component3();
                String detail = lintError.component4();
                PrintStream printStream = this.out;
                StringBuilder stringBuilder = new StringBuilder().append("  ").append(line);
                PlainReporter plainReporter = this;
                StringBuilder stringBuilder2 = new StringBuilder().append(':');
                if (this.pad) {
                    String string2;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string3 = "%-3s";
                    Object[] objectArray = new Object[]{col};
                    StringBuilder stringBuilder3 = stringBuilder2;
                    PlainReporter plainReporter2 = plainReporter;
                    StringBuilder stringBuilder4 = stringBuilder;
                    PrintStream printStream2 = printStream;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    printStream = printStream2;
                    stringBuilder = stringBuilder4;
                    plainReporter = plainReporter2;
                    stringBuilder2 = stringBuilder3;
                    string = string2;
                } else {
                    string = String.valueOf(col);
                }
                printStream.println(stringBuilder.append(plainReporter.colored(stringBuilder2.append(string).toString())).append(' ').append(detail).append(this.verbose ? this.colored(" (" + ruleId + ')') : "").toString());
            }
        }
    }

    private final String colorFileName(String fileName) {
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.separator");
        String name = StringsKt.substringAfterLast$default((String)fileName, (String)string, null, (int)2, null);
        String string2 = fileName;
        int n = 0;
        int n2 = fileName.length() - name.length();
        PlainReporter plainReporter = this;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string5 = string4;
        return stringBuilder.append(plainReporter.colored(string5)).append(name).toString();
    }

    private final String colored(@NotNull String $this$colored) {
        return this.shouldColorOutput ? ColorKt.color($this$colored, this.outputColor) : $this$colored;
    }

    @NotNull
    public final PrintStream getOut() {
        return this.out;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final boolean getGroupByFile() {
        return this.groupByFile;
    }

    public final boolean getShouldColorOutput() {
        return this.shouldColorOutput;
    }

    @NotNull
    public final Color getOutputColor() {
        return this.outputColor;
    }

    public final boolean getPad() {
        return this.pad;
    }

    public PlainReporter(@NotNull PrintStream out, boolean verbose, boolean groupByFile, boolean shouldColorOutput, @NotNull Color outputColor, boolean pad) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)((Object)outputColor), (String)"outputColor");
        this.out = out;
        this.verbose = verbose;
        this.groupByFile = groupByFile;
        this.shouldColorOutput = shouldColorOutput;
        this.outputColor = outputColor;
        this.pad = pad;
        this.acc = new ConcurrentHashMap();
    }

    public /* synthetic */ PlainReporter(PrintStream printStream, boolean bl, boolean bl2, boolean bl3, Color color, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            color = Color.DARK_GRAY;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        this(printStream, bl, bl2, bl3, color, bl4);
    }

    public void afterAll() {
        Reporter.DefaultImpls.afterAll((Reporter)this);
    }

    public void before(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Reporter.DefaultImpls.before((Reporter)this, (String)file);
    }

    public void beforeAll() {
        Reporter.DefaultImpls.beforeAll((Reporter)this);
    }
}

