
package com.prowidesoftware.swift.model.mx.dic;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * The CurrencyControlStatusAdvice message is sent by either the reporting party (respectively the registration agent) or the registration agent (respectively the reporting party) to provide a status advice on a previously sent currency control message.
 * 
 * Usage: 
 * The message may be sent in response to requests on the registration of the currency control contract, supporting document or on the payment regulatory information notification.
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CurrencyControlStatusAdviceV03", propOrder = {
    "grpHdr",
    "grpSts",
    "packgSts",
    "splmtryData"
})
public class CurrencyControlStatusAdviceV03 {

    @XmlElement(name = "GrpHdr", required = true)
    protected CurrencyControlHeader6 grpHdr;
    @XmlElement(name = "GrpSts", required = true)
    protected List<CurrencyControlGroupStatus2> grpSts;
    @XmlElement(name = "PackgSts")
    protected List<CurrencyControlPackageStatus2> packgSts;
    @XmlElement(name = "SplmtryData")
    protected List<SupplementaryData1> splmtryData;

    /**
     * Gets the value of the grpHdr property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyControlHeader6 }
     *     
     */
    public CurrencyControlHeader6 getGrpHdr() {
        return grpHdr;
    }

    /**
     * Sets the value of the grpHdr property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyControlHeader6 }
     *     
     */
    public CurrencyControlStatusAdviceV03 setGrpHdr(CurrencyControlHeader6 value) {
        this.grpHdr = value;
        return this;
    }

    /**
     * Gets the value of the grpSts property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the grpSts property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGrpSts().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CurrencyControlGroupStatus2 }
     * 
     * 
     * @return
     *     The value of the grpSts property.
     */
    public List<CurrencyControlGroupStatus2> getGrpSts() {
        if (grpSts == null) {
            grpSts = new ArrayList<>();
        }
        return this.grpSts;
    }

    /**
     * Gets the value of the packgSts property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the packgSts property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPackgSts().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CurrencyControlPackageStatus2 }
     * 
     * 
     * @return
     *     The value of the packgSts property.
     */
    public List<CurrencyControlPackageStatus2> getPackgSts() {
        if (packgSts == null) {
            packgSts = new ArrayList<>();
        }
        return this.packgSts;
    }

    /**
     * Gets the value of the splmtryData property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the splmtryData property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSplmtryData().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupplementaryData1 }
     * 
     * 
     * @return
     *     The value of the splmtryData property.
     */
    public List<SupplementaryData1> getSplmtryData() {
        if (splmtryData == null) {
            splmtryData = new ArrayList<>();
        }
        return this.splmtryData;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    /**
     * Adds a new item to the grpSts list.
     * @see #getGrpSts()
     * 
     */
    public CurrencyControlStatusAdviceV03 addGrpSts(CurrencyControlGroupStatus2 grpSts) {
        getGrpSts().add(grpSts);
        return this;
    }

    /**
     * Adds a new item to the packgSts list.
     * @see #getPackgSts()
     * 
     */
    public CurrencyControlStatusAdviceV03 addPackgSts(CurrencyControlPackageStatus2 packgSts) {
        getPackgSts().add(packgSts);
        return this;
    }

    /**
     * Adds a new item to the splmtryData list.
     * @see #getSplmtryData()
     * 
     */
    public CurrencyControlStatusAdviceV03 addSplmtryData(SupplementaryData1 splmtryData) {
        getSplmtryData().add(splmtryData);
        return this;
    }

}
