/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field15A;
import com.prowidesoftware.swift.model.field.Field15B;
import com.prowidesoftware.swift.model.field.Field15C;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field22A;
import com.prowidesoftware.swift.model.field.Field23B;
import com.prowidesoftware.swift.model.field.Field23S;
import com.prowidesoftware.swift.model.field.Field23X;
import com.prowidesoftware.swift.model.field.Field24E;
import com.prowidesoftware.swift.model.field.Field24G;
import com.prowidesoftware.swift.model.field.Field26E;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field31E;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field35G;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field59A;
import com.prowidesoftware.swift.model.field.Field72Z;
import com.prowidesoftware.swift.model.field.Field77L;
import com.prowidesoftware.swift.model.field.Field77U;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT767
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT767.class.getName());
    public static final String NAME = "767";

    public MT767(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT767(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT767 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT767(m);
    }

    public MT767() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT767(String sender, String receiver) {
        super(767, sender, receiver);
    }

    public MT767(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT767.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT767 object from FIN content with a Service Message. Check if the MT767 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT767 object from FIN content with message type " + param.getType());
        }
    }

    public static MT767 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT767(fin);
    }

    public MT767(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT767 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT767(stream);
    }

    public MT767(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT767 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT767(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT767 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT767 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT767 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT767 fromJson(String json) {
        return (MT767)AbstractMT.fromJson(json);
    }

    public Field15A getField15A() {
        Tag t = this.tag("15A");
        if (t != null) {
            return new Field15A(t.getValue());
        }
        return null;
    }

    public Field27 getField27() {
        Tag t = this.tag("27");
        if (t != null) {
            return new Field27(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field22A getField22A() {
        Tag t = this.tag("22A");
        if (t != null) {
            return new Field22A(t.getValue());
        }
        return null;
    }

    public Field23S getField23S() {
        Tag t = this.tag("23S");
        if (t != null) {
            return new Field23S(t.getValue());
        }
        return null;
    }

    public Field72Z getField72Z() {
        Tag t = this.tag("72Z");
        if (t != null) {
            return new Field72Z(t.getValue());
        }
        return null;
    }

    public Field23X getField23X() {
        Tag t = this.tag("23X");
        if (t != null) {
            return new Field23X(t.getValue());
        }
        return null;
    }

    public Field15B getField15B() {
        Tag t = this.tag("15B");
        if (t != null) {
            return new Field15B(t.getValue());
        }
        return null;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field26E getField26E() {
        Tag t = this.tag("26E");
        if (t != null) {
            return new Field26E(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field59A getField59A() {
        Tag t = this.tag("59A");
        if (t != null) {
            return new Field59A(t.getValue());
        }
        return null;
    }

    public Field77U getField77U() {
        Tag t = this.tag("77U");
        if (t != null) {
            return new Field77U(t.getValue());
        }
        return null;
    }

    public Field15C getField15C() {
        Tag t = this.tag("15C");
        if (t != null) {
            return new Field15C(t.getValue());
        }
        return null;
    }

    public Field77L getField77L() {
        Tag t = this.tag("77L");
        if (t != null) {
            return new Field77L(t.getValue());
        }
        return null;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field33B> getField33B() {
        ArrayList<Field33B> result = new ArrayList<Field33B>();
        Tag[] tags = this.tags("33B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field33B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field23B> getField23B() {
        ArrayList<Field23B> result = new ArrayList<Field23B>();
        Tag[] tags = this.tags("23B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field23B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field31E> getField31E() {
        ArrayList<Field31E> result = new ArrayList<Field31E>();
        Tag[] tags = this.tags("31E");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field31E(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field35G> getField35G() {
        ArrayList<Field35G> result = new ArrayList<Field35G>();
        Tag[] tags = this.tags("35G");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field35G(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field59> getField59() {
        ArrayList<Field59> result = new ArrayList<Field59>();
        Tag[] tags = this.tags("59");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field59(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field24E> getField24E() {
        ArrayList<Field24E> result = new ArrayList<Field24E>();
        Tag[] tags = this.tags("24E");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field24E(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field24G> getField24G() {
        ArrayList<Field24G> result = new ArrayList<Field24G>();
        Tag[] tags = this.tags("24G");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field24G(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("A")) {
            return new SequenceA(map.get("A"));
        }
        return new SequenceA();
    }

    public SequenceB getSequenceB() {
        return this.getSequenceB(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceB getSequenceB(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("B")) {
            return new SequenceB(map.get("B"));
        }
        return new SequenceB();
    }

    public SequenceC getSequenceC() {
        return this.getSequenceC(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceC getSequenceC(SwiftTagListBlock parentSequence) {
        Map<String, SwiftTagListBlock> map = SwiftMessageUtils.splitByField15(parentSequence);
        if (map.containsKey("C")) {
            return new SequenceC(map.get("C"));
        }
        return new SequenceC();
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15C.emptyTag();

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC newInstance(Tag ... tags) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceC newInstance() {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            return result;
        }

        public static SequenceC newInstance(SwiftTagListBlock ... sequences) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15B.emptyTag();

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final Tag START_TAG = Field15A.emptyTag();

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            return result;
        }
    }
}

