/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field38J
extends Field
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "38J";
    public static final String F_38J = "38J";
    @Deprecated
    public static final String PARSER_PATTERN = "SN";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SN";
    @Deprecated
    public static final String TYPES_PATTERN = "SN";
    public static final Integer INDICATOR = 1;
    @Deprecated
    public static final Integer DM_MARK = 1;
    public static final Integer NUMBER = 2;

    public Field38J() {
        super(2);
    }

    public Field38J(String value) {
        super(value);
    }

    public Field38J(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"38J")) {
            throw new IllegalArgumentException("cannot create field 38J from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field38J newInstance(Field38J source) {
        Field38J cp = new Field38J();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("38J", value);
    }

    public static Tag emptyTag() {
        return new Tag("38J", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 38J");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SN";
    }

    @Override
    public String typesPattern() {
        return "SN";
    }

    @Override
    public String parserPattern() {
        return "SN";
    }

    @Override
    public String validatorPattern() {
        return "<DM>3!n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Indicator");
        result.add("Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "indicator");
        result.put(2, "number");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("indicator", 1);
        this.labelMap.put("dmmark", 1);
        this.labelMap.put("number", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getIndicator() {
        return this.getComponent1();
    }

    @Deprecated
    public String getDMMark() {
        return this.getIndicator();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        Long l = this.getComponent2AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getNumber() {
        return this.getComponent2();
    }

    public Long getNumberAsLong() {
        return this.getComponent2AsLong();
    }

    @Deprecated
    public Number getNumberAsNumber() {
        return this.getComponent2AsNumber();
    }

    public Field38J setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field38J setIndicator(String component1) {
        return this.setComponent1(component1);
    }

    @Deprecated
    public Field38J setDMMark(String component1) {
        return this.setIndicator(component1);
    }

    public Field38J setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field38J setComponent2(Long component2) {
        this.setComponent(2, SwiftFormatUtils.getLong(component2));
        return this;
    }

    public Field38J setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field38J setNumber(String component2) {
        return this.setComponent2(component2);
    }

    public Field38J setNumber(Long component2) {
        return this.setComponent2(component2);
    }

    public Field38J setNumber(Number component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "38J";
    }

    public static Field38J get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("38J");
        if (t == null) {
            return null;
        }
        return new Field38J(t);
    }

    public static Field38J get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field38J.get(msg.getBlock4());
    }

    public static List<Field38J> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field38J.getAll(msg.getBlock4());
    }

    public static List<Field38J> getAll(SwiftTagListBlock block) {
        ArrayList<Field38J> result = new ArrayList<Field38J>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("38J");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field38J(f));
            }
        }
        return result;
    }

    public static Field38J fromJson(String json) {
        Field38J field = new Field38J();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("dMMark") != null) {
            field.setComponent1(jsonObject.get("dMMark").getAsString());
        }
        if (jsonObject.get("indicator") != null) {
            field.setComponent1(jsonObject.get("indicator").getAsString());
        }
        if (jsonObject.get("number") != null) {
            field.setComponent2(jsonObject.get("number").getAsString());
        }
        return field;
    }
}

