/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field93D
extends Field
implements Serializable,
AmountContainer,
GenericField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "93D";
    public static final String F_93D = "93D";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//[S]N";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSN";
    @Deprecated
    public static final String TYPES_PATTERN = "SSI";
    public static final Integer QUALIFIER = 1;
    public static final Integer SIGN = 2;
    public static final Integer BALANCE = 3;
    @Deprecated
    public static final Integer AMOUNT = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field93D() {
        super(3);
    }

    public Field93D(String value) {
        super(value);
    }

    public Field93D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"93D")) {
            throw new IllegalArgumentException("cannot create field 93D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field93D newInstance(Field93D source) {
        Field93D cp = new Field93D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("93D", value);
    }

    public static Tag emptyTag() {
        return new Tag("93D", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 93D");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent3AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//[<N>]<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Sign");
        result.add("Balance");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "sign");
        result.put(3, "balance");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("sign", 2);
        this.labelMap.put("balance", 3);
        this.labelMap.put("amount", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getSign() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BigDecimal getComponent3AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(3));
    }

    @Deprecated
    public Number getComponent3AsNumber() {
        return this.getComponent3AsBigDecimal();
    }

    public String getBalance() {
        return this.getComponent3();
    }

    @Deprecated
    public String getAmount() {
        return this.getBalance();
    }

    public BigDecimal getBalanceAsBigDecimal() {
        return this.getComponent3AsBigDecimal();
    }

    @Deprecated
    public Number getBalanceAsNumber() {
        return this.getComponent3AsNumber();
    }

    @Deprecated
    public BigDecimal getAmountAsBigDecimal() {
        return this.getBalanceAsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getBalanceAsNumber();
    }

    public Field93D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field93D setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field93D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field93D setSign(String component2) {
        return this.setComponent2(component2);
    }

    public Field93D setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field93D setComponent3(BigDecimal component3) {
        this.setComponent(3, SwiftFormatUtils.getBigDecimal(component3));
        return this;
    }

    public Field93D setComponent3(Number component3) {
        if (component3 instanceof BigDecimal) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal((BigDecimal)component3));
        } else if (component3 instanceof BigInteger) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component3)));
        } else if (component3 instanceof Long || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.longValue())));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.doubleValue())));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field93D setBalance(String component3) {
        return this.setComponent3(component3);
    }

    public Field93D setBalance(BigDecimal component3) {
        return this.setComponent3(component3);
    }

    public Field93D setBalance(Number component3) {
        return this.setComponent3(component3);
    }

    @Deprecated
    public Field93D setAmount(String component3) {
        return this.setBalance(component3);
    }

    @Deprecated
    public Field93D setAmount(BigDecimal component3) {
        return this.setBalance(component3);
    }

    @Deprecated
    public Field93D setAmount(Number component3) {
        return this.setBalance(component3);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "93D";
    }

    public static Field93D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("93D");
        if (t == null) {
            return null;
        }
        return new Field93D(t);
    }

    public static Field93D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field93D.get(msg.getBlock4());
    }

    public static List<Field93D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field93D.getAll(msg.getBlock4());
    }

    public static List<Field93D> getAll(SwiftTagListBlock block) {
        ArrayList<Field93D> result = new ArrayList<Field93D>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("93D");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field93D(f));
            }
        }
        return result;
    }

    public static Field93D fromJson(String json) {
        Field93D field = new Field93D();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent2(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent3(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("balance") != null) {
            field.setComponent3(jsonObject.get("balance").getAsString());
        }
        return field;
    }
}

