/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.parser;

import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SafeXmlUtils;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLParser {
    private static final transient Logger log = Logger.getLogger(XMLParser.class.getName());
    private static final String UNPARSEDTEXTS = "unparsedtexts";

    public SwiftMessage parse(String xml) {
        Validate.isTrue((xml != null ? 1 : 0) != 0);
        try {
            DocumentBuilder db = SafeXmlUtils.documentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
            return this.createMessage(doc);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error parsing XML", e);
            return null;
        }
    }

    private SwiftMessage createMessage(Document doc) {
        NodeList messageNL = doc.getElementsByTagName("message");
        if (messageNL.getLength() == 1) {
            Node message = messageNL.item(0);
            SwiftMessage m = new SwiftMessage(false);
            NodeList blocksNL = message.getChildNodes();
            if (log.isLoggable(Level.FINE)) {
                log.fine("blocks in message: " + blocksNL.getLength());
            }
            for (int i = 0; i < blocksNL.getLength(); ++i) {
                Node blockNode = blocksNL.item(i);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("evaluating node " + blockNode.getNodeName());
                }
                if (blockNode.getNodeType() != 1) continue;
                String blockName = blockNode.getNodeName();
                if ("block1".equalsIgnoreCase(blockName)) {
                    m.setBlock1(this.getBlock1FromNode(blockNode));
                    continue;
                }
                if ("block2".equalsIgnoreCase(blockName)) {
                    m.setBlock2(this.getBlock2FromNode(blockNode));
                    continue;
                }
                if (UNPARSEDTEXTS.equalsIgnoreCase(blockName)) {
                    m.setUnparsedTexts(this.getUnparsedTextsFromNode(blockNode));
                    continue;
                }
                m.addBlock(this.getTagListBlockFromNode(blockNode));
            }
            return m;
        }
        throw new IllegalArgumentException("<message> tag not found");
    }

    private SwiftBlock1 getBlock1FromNode(Node blockNode) {
        NodeList fields = blockNode.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(fields.getLength() + " children in <block1>");
        }
        SwiftBlock1 b1 = new SwiftBlock1();
        for (int i = 0; i < fields.getLength(); ++i) {
            Node n = fields.item(i);
            if ("APPLICATIONID".equalsIgnoreCase(n.getNodeName())) {
                b1.setApplicationId(this.getText(n));
                continue;
            }
            if ("SERVICEID".equalsIgnoreCase(n.getNodeName())) {
                b1.setServiceId(this.getText(n));
                continue;
            }
            if ("LOGICALTERMINAL".equalsIgnoreCase(n.getNodeName())) {
                b1.setLogicalTerminal(this.getText(n));
                continue;
            }
            if ("SESSIONNUMBER".equalsIgnoreCase(n.getNodeName())) {
                b1.setSessionNumber(this.getText(n));
                continue;
            }
            if ("SEQUENCENUMBER".equalsIgnoreCase(n.getNodeName())) {
                b1.setSequenceNumber(this.getText(n));
                continue;
            }
            if (!UNPARSEDTEXTS.equalsIgnoreCase(n.getNodeName())) continue;
            b1.setUnparsedTexts(this.getUnparsedTextsFromNode(n));
        }
        return b1;
    }

    private String getText(Node n) {
        String text = null;
        Node c = n.getFirstChild();
        if (c != null) {
            if (c.getNodeType() == 3) {
                text = c.getNodeValue();
            } else {
                log.warning("Node is not TEXT_NODE: " + c);
            }
        }
        return text;
    }

    private SwiftBlock2 getBlock2FromNode(Node blockNode) {
        String type = this.getNodeAttribute(blockNode, "type");
        if (type == null) {
            log.severe("atrribute 'type' was expected but not found at <block2> xml tag");
            return null;
        }
        if ("input".equals(type)) {
            return this.getBlock2InputFromNode(blockNode);
        }
        if ("output".equals(type)) {
            return this.getBlock2OutputFromNode(blockNode);
        }
        log.severe("expected 'input' or 'output' value for 'type' atribute at <block2> xml tag, and found: " + type);
        return null;
    }

    private SwiftBlock2Input getBlock2InputFromNode(Node blockNode) {
        NodeList fields = blockNode.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(fields.getLength() + " childrens in <block2 type=\"input\">");
        }
        SwiftBlock2Input b2 = new SwiftBlock2Input();
        for (int i = 0; i < fields.getLength(); ++i) {
            Node n = fields.item(i);
            if ("MESSAGETYPE".equalsIgnoreCase(n.getNodeName())) {
                b2.setMessageType(this.getText(n));
                continue;
            }
            if ("RECEIVERADDRESS".equalsIgnoreCase(n.getNodeName())) {
                b2.setReceiverAddress(this.getText(n));
                continue;
            }
            if ("MESSAGEPRIORITY".equalsIgnoreCase(n.getNodeName())) {
                b2.setMessagePriority(this.getText(n));
                continue;
            }
            if ("DELIVERYMONITORING".equalsIgnoreCase(n.getNodeName())) {
                b2.setDeliveryMonitoring(this.getText(n));
                continue;
            }
            if ("OBSOLESCENCEPERIOD".equalsIgnoreCase(n.getNodeName())) {
                b2.setObsolescencePeriod(this.getText(n));
                continue;
            }
            if (!UNPARSEDTEXTS.equalsIgnoreCase(n.getNodeName())) continue;
            b2.setUnparsedTexts(this.getUnparsedTextsFromNode(n));
        }
        return b2;
    }

    private SwiftBlock2Output getBlock2OutputFromNode(Node blockNode) {
        NodeList fields = blockNode.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(fields.getLength() + " childrens in <block2 type=\"output\">");
        }
        SwiftBlock2Output b2 = new SwiftBlock2Output();
        for (int i = 0; i < fields.getLength(); ++i) {
            Node n = fields.item(i);
            if ("MESSAGETYPE".equalsIgnoreCase(n.getNodeName())) {
                b2.setMessageType(this.getText(n));
                continue;
            }
            if ("SENDERINPUTTIME".equalsIgnoreCase(n.getNodeName())) {
                b2.setSenderInputTime(this.getText(n));
                continue;
            }
            if ("MIRDATE".equalsIgnoreCase(n.getNodeName())) {
                b2.setMIRDate(this.getText(n));
                continue;
            }
            if ("MIRLOGICALTERMINAL".equalsIgnoreCase(n.getNodeName())) {
                b2.setMIRLogicalTerminal(this.getText(n));
                continue;
            }
            if ("MIRSESSIONNUMBER".equalsIgnoreCase(n.getNodeName())) {
                b2.setMIRSessionNumber(this.getText(n));
                continue;
            }
            if ("MIRSEQUENCENUMBER".equalsIgnoreCase(n.getNodeName())) {
                b2.setMIRSequenceNumber(this.getText(n));
                continue;
            }
            if ("RECEIVEROUTPUTDATE".equalsIgnoreCase(n.getNodeName())) {
                b2.setReceiverOutputDate(this.getText(n));
                continue;
            }
            if ("RECEIVEROUTPUTTIME".equalsIgnoreCase(n.getNodeName())) {
                b2.setReceiverOutputTime(this.getText(n));
                continue;
            }
            if ("MESSAGEPRIORITY".equalsIgnoreCase(n.getNodeName())) {
                b2.setMessagePriority(this.getText(n));
                continue;
            }
            if (!UNPARSEDTEXTS.equalsIgnoreCase(n.getNodeName())) continue;
            b2.setUnparsedTexts(this.getUnparsedTextsFromNode(n));
        }
        return b2;
    }

    private SwiftTagListBlock getTagListBlockFromNode(Node blockNode) {
        SwiftTagListBlock b;
        String blockName = blockNode.getNodeName();
        if ("block3".equalsIgnoreCase(blockName)) {
            b = new SwiftBlock3();
        } else if ("block4".equalsIgnoreCase(blockName)) {
            b = new SwiftBlock4();
        } else if ("block5".equalsIgnoreCase(blockName)) {
            b = new SwiftBlock5();
        } else if ("block".equalsIgnoreCase(blockName)) {
            String name = this.getNodeAttribute(blockNode, "name");
            b = name != null ? new SwiftBlockUser(name) : new SwiftBlockUser();
        } else {
            return null;
        }
        NodeList fields = blockNode.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(fields.getLength() + " children in tag list " + blockName);
        }
        for (int j = 0; j < fields.getLength(); ++j) {
            Node t = fields.item(j);
            if ("tag".equalsIgnoreCase(t.getNodeName())) {
                Tag tag = this.getTag(t);
                b.append(tag);
                continue;
            }
            if ("field".equalsIgnoreCase(t.getNodeName())) {
                Field field = this.getField(t);
                b.append(field);
                continue;
            }
            if (!UNPARSEDTEXTS.equalsIgnoreCase(t.getNodeName())) continue;
            b.setUnparsedTexts(this.getUnparsedTextsFromNode(t));
        }
        return b;
    }

    private Tag getTag(Node t) {
        Tag tag = new Tag();
        NodeList children = t.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if ("name".equalsIgnoreCase(n.getNodeName())) {
                tag.setName(this.getText(n));
            }
            if ("value".equalsIgnoreCase(n.getNodeName())) {
                String text = StringEscapeUtils.unescapeXml((String)this.getText(n));
                text = StringUtils.replace((String)text, (String)"\n", (String)"\r\n");
                tag.setValue(text);
                continue;
            }
            if (!UNPARSEDTEXTS.equalsIgnoreCase(n.getNodeName())) continue;
            tag.setUnparsedTexts(this.getUnparsedTextsFromNode(n));
        }
        return tag;
    }

    private Field getField(Node t) {
        NodeList children = t.getChildNodes();
        String name = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!"name".equalsIgnoreCase(n.getNodeName())) continue;
            name = this.getText(n);
            break;
        }
        if (name != null) {
            Field field = Field.getField(name, null);
            for (int i = 0; i < children.getLength(); ++i) {
                String number;
                Node n = children.item(i);
                if (!"component".equalsIgnoreCase(n.getNodeName()) || !StringUtils.isNumeric((CharSequence)(number = this.getNodeAttribute(n, "number")))) continue;
                String text = StringEscapeUtils.unescapeXml((String)this.getText(n));
                text = StringUtils.replace((String)text, (String)"\n", (String)"\r\n");
                try {
                    field.setComponent(Integer.parseInt(number), text);
                    continue;
                }
                catch (NumberFormatException e) {
                    log.warning("error setting component " + number + " for field " + name + ": " + e.getMessage());
                    return null;
                }
            }
            return field;
        }
        return null;
    }

    private UnparsedTextList getUnparsedTextsFromNode(Node blockNode) {
        UnparsedTextList unparsedTexts = new UnparsedTextList();
        NodeList texts = blockNode.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(texts.getLength() + " children in <unparsedtexts>");
        }
        for (int j = 0; j < texts.getLength(); ++j) {
            Node t = texts.item(j);
            if (!"text".equalsIgnoreCase(t.getNodeName())) continue;
            unparsedTexts.addText(this.getText(t));
        }
        return unparsedTexts;
    }

    private String getNodeAttribute(Node n, String attributeName) {
        Node attr = n.getAttributes().getNamedItem(attributeName);
        if (attr == null || !attr.getNodeName().equals(attributeName)) {
            return null;
        }
        return attr.getNodeValue();
    }
}

