/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.io.ConversionService;
import com.prowidesoftware.swift.model.SwiftMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class UnparsedTextList
implements Serializable {
    private static final long serialVersionUID = 7302986014143689797L;
    private static final String WRITER_MESSAGE = "parameter 'index' cannot be null";
    private List<String> texts = new ArrayList<String>();

    public UnparsedTextList() {
    }

    public UnparsedTextList(Collection<String> texts) {
        Objects.requireNonNull(texts, "parameter 'texts' cannot be null");
        this.texts = new ArrayList<String>(texts);
    }

    public static Boolean isMessage(String text) {
        return text != null && text.contains("{1:");
    }

    public String getAsFINString() {
        if (this.texts.isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (String text : this.texts) {
            s.append(text);
        }
        return s.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public List<String> getTexts() {
        return this.texts;
    }

    protected void setTexts(List<String> texts) {
        this.texts = texts;
    }

    public Integer size() {
        return this.texts.size();
    }

    public Boolean isMessage(Integer index) {
        return UnparsedTextList.isMessage(this.getText(index));
    }

    public String getText(Integer index) {
        Objects.requireNonNull(index, WRITER_MESSAGE);
        return this.texts.get(index);
    }

    public SwiftMessage getTextAsMessage(Integer index) {
        Objects.requireNonNull(index, WRITER_MESSAGE);
        return new ConversionService().getMessageFromFIN(this.texts.get(index));
    }

    public void addText(String text) {
        Objects.requireNonNull(text, "parameter 'text' cannot be null");
        this.texts.add(text);
    }

    public void addText(SwiftMessage message) {
        Objects.requireNonNull(message, "parameter 'message' cannot be null");
        ConversionService cService = new ConversionService();
        String msg = cService.getFIN(message);
        this.addText(msg);
    }

    public void removeText(int index) {
        this.texts.remove(index);
    }

    public void removeText(String text) {
        Objects.requireNonNull(text, "parameter 'text' cannot be null");
        int pos = this.texts.indexOf(text);
        if (pos != -1) {
            this.texts.remove(pos);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnparsedTextList that = (UnparsedTextList)o;
        return Objects.equals(this.texts, that.texts);
    }

    public int hashCode() {
        return Objects.hash(this.texts);
    }
}

