/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;

public class JavadocTag {
    private final int lineNo;
    private final int columnNo;
    private final String firstArg;
    private final JavadocTagInfo tagInfo;

    public JavadocTag(int line, int column, String tag, String firstArg) {
        this.lineNo = line;
        this.columnNo = column;
        this.firstArg = firstArg;
        this.tagInfo = JavadocTagInfo.fromName(tag);
    }

    public JavadocTag(int line, int column, String tag) {
        this(line, column, tag, null);
    }

    public String getTagName() {
        return this.tagInfo.getName();
    }

    public String getFirstArg() {
        return this.firstArg;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public String toString() {
        return "JavadocTag[tag='" + this.tagInfo.getName() + "' lineNo=" + this.lineNo + ", columnNo=" + this.columnNo + ", firstArg='" + this.firstArg + "']";
    }

    public boolean isReturnTag() {
        return this.tagInfo == JavadocTagInfo.RETURN;
    }

    public boolean isParamTag() {
        return this.tagInfo == JavadocTagInfo.PARAM;
    }

    public boolean isThrowsTag() {
        return this.tagInfo == JavadocTagInfo.THROWS || this.tagInfo == JavadocTagInfo.EXCEPTION;
    }

    public boolean isSeeOrInheritDocTag() {
        return this.tagInfo == JavadocTagInfo.SEE || this.isInheritDocTag();
    }

    public boolean isInheritDocTag() {
        return this.tagInfo == JavadocTagInfo.INHERIT_DOC;
    }

    public boolean canReferenceImports() {
        return this.tagInfo == JavadocTagInfo.SEE || this.tagInfo == JavadocTagInfo.LINK || this.tagInfo == JavadocTagInfo.VALUE || this.tagInfo == JavadocTagInfo.LINKPLAIN || this.tagInfo == JavadocTagInfo.THROWS || this.tagInfo == JavadocTagInfo.EXCEPTION;
    }
}

