/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.jasperreports.auth;

import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.rsmart.rfabric.auth.tokenauth.AuthToken;
import com.rsmart.rfabric.auth.tokenauth.springsecurity.AuthTokenAuthentication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

public class AuthTokenAuthenticationUtil {
    private static final Log LOG = LogFactory.getLog(AuthTokenAuthenticationUtil.class);

    public static AuthToken getCurrentAuthToken() {
        AuthTokenAuthentication ourAuthObject = null;
        AuthToken token = null;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            if (auth.getPrincipal() instanceof MetadataUserDetails) {
                MetadataUserDetails userDetails = (MetadataUserDetails)auth.getPrincipal();
                Authentication origAuth = userDetails.getOriginalAuthentication();
                if (origAuth != null && origAuth instanceof AuthTokenAuthentication) {
                    ourAuthObject = (AuthTokenAuthentication)origAuth;
                }
            } else if (auth instanceof AuthTokenAuthentication) {
                ourAuthObject = (AuthTokenAuthentication)auth;
            } else {
                LOG.error((Object)("cannot obtain authtoken from curent Authentication object for this user's session. Authentication type is: " + auth.getClass().getName()));
                return null;
            }
            if (ourAuthObject != null) {
                token = (AuthToken)ourAuthObject.getCredentials();
            }
        }
        return token;
    }
}

