/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.jasperreports.auth;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.BuiltInParameterProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JRQueryExecuterAdapter;
import com.rsmart.rfabric.auth.tokenauth.AuthToken;
import com.rsmart.rfabric.jasperreports.auth.AuthTokenAuthenticationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KCUserParameterProvider
implements BuiltInParameterProvider {
    private static final Log LOG = LogFactory.getLog(KCUserParameterProvider.class);

    public List<Object[]> getParameters(ExecutionContext context, List jrParameters, Map parameters) {
        LOG.debug((Object)"getParameters called");
        ArrayList<Object[]> userProfileParameters = new ArrayList<Object[]>();
        for (String parameterName : new String[]{"KCID", "ISPI", "client"}) {
            Object[] result = this.getParameter(context, jrParameters, parameters, parameterName);
            if (result == null) continue;
            userProfileParameters.add(result);
        }
        return userProfileParameters;
    }

    public Object[] getParameter(ExecutionContext context, List jrParameters, Map parameters, String name) {
        LOG.debug((Object)("getParameter called for param '" + name + "'"));
        AuthToken token = AuthTokenAuthenticationUtil.getCurrentAuthToken();
        if (token == null) {
            return null;
        }
        JRParameter param = null;
        Object value = null;
        if (name.equalsIgnoreCase("KCID")) {
            LOG.trace((Object)"KCID parameter requested");
            String kcid = token.getCredentialField("KCID");
            param = JRQueryExecuterAdapter.makeParameter((String)name, String.class);
            value = kcid != null ? kcid : "";
        } else if (name.equalsIgnoreCase("ISPI")) {
            LOG.trace((Object)"ISPI parameter requested");
            String isPI = token.getCredentialField("ISPI");
            param = JRQueryExecuterAdapter.makeParameter((String)name, Boolean.class);
            value = Boolean.parseBoolean(isPI);
        } else if (name.equalsIgnoreCase("client")) {
            LOG.trace((Object)"'client' parameter requested");
            String client = token.getCredentialField("client");
            param = JRQueryExecuterAdapter.makeParameter((String)name, String.class);
            Object object = value = client != null ? client : "";
        }
        if (param != null && value != null) {
            LOG.trace((Object)("returning param: " + param.toString() + " value: " + value.toString()));
            return new Object[]{param, value};
        }
        return null;
    }
}

