/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.jasperreports.datasource.xml;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.JdbcReportDataSourceImpl;
import com.rsmart.rfabric.jasperreports.datasource.ClientDataSourceService;
import com.rsmart.rfabric.jasperreports.datasource.xml.Configuration;
import com.rsmart.rfabric.jasperreports.datasource.xml.DbConnectionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class XmlClientDataSourceServiceImpl
implements ClientDataSourceService,
ResourceLoaderAware {
    private static final Log LOG = LogFactory.getLog(XmlClientDataSourceServiceImpl.class);
    protected String dataSourceFile;
    protected Map<String, JdbcReportDataSource> connections;
    protected ResourceLoader resourceLoader;

    public void init() {
        InputStream configStream;
        if (this.dataSourceFile == null) {
            LOG.fatal((Object)"config file not set");
            throw new IllegalStateException("data source config file not set");
        }
        LOG.info((Object)("data sources being read from: " + this.dataSourceFile));
        Resource configResource = this.resourceLoader.getResource(this.dataSourceFile);
        try {
            configStream = configResource.getInputStream();
        }
        catch (IOException ioe) {
            LOG.fatal((Object)"Error obtaining configuration file InputStream", (Throwable)ioe);
            throw new IllegalStateException("Error obtaining configuration file InputStream", ioe);
        }
        Configuration configuration = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            configuration = (Configuration)jaxbUnmarshaller.unmarshal(configStream);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Error parsing configuration file", (Throwable)e);
            throw new IllegalStateException("Could not parse configuration", e);
        }
        finally {
            try {
                configStream.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error closing configuration file", (Throwable)e);
            }
        }
        ArrayList<DbConnectionInfo> connections = configuration.getConnections();
        this.connections = new HashMap<String, JdbcReportDataSource>(connections.size());
        for (DbConnectionInfo connection : connections) {
            JdbcReportDataSourceImpl ds = new JdbcReportDataSourceImpl();
            ds.setConnectionUrl(connection.getUrl());
            ds.setDriverClass(connection.getDriver());
            ds.setUsername(connection.getUser());
            ds.setPassword(connection.getPassword());
            LOG.debug((Object)("adding DB configuration for client '" + connection.getClient() + "'"));
            this.connections.put(connection.getClient(), (JdbcReportDataSource)ds);
        }
    }

    @Override
    public JdbcReportDataSource getDataSourceServiceForClient(String client) {
        if (!this.connections.containsKey(client)) {
            LOG.error((Object)("No connection info exists for client '" + client + "'"));
            throw new IllegalArgumentException("No connection info for '" + client + "'");
        }
        return this.connections.get(client);
    }

    @Override
    public JdbcReportDataSource getDataSourceServiceForUser(String userId) {
        if (!this.connections.containsKey(userId)) {
            LOG.error((Object)("No connection info exists for client '" + userId + "'"));
            throw new IllegalArgumentException("No connection info for '" + userId + "'");
        }
        return this.connections.get(userId);
    }

    public String getDataSourceFile() {
        return this.dataSourceFile;
    }

    public void setDataSourceFile(String dataSourceFile) {
        this.dataSourceFile = dataSourceFile;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.resourceLoader = loader;
    }
}

