/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.jasperreports.dbswitcher;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.service.BeanForInterfaceImplementationFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcDataSourceService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.rsmart.rfabric.auth.tokenauth.AuthToken;
import com.rsmart.rfabric.jasperreports.auth.AuthTokenAuthenticationUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class SwitchingDataSource
implements ReportDataSourceService {
    private static final Log LOG = LogFactory.getLog(SwitchingDataSource.class);
    private RepositoryService repositoryService;
    private BeanForInterfaceImplementationFactory dataSourceService;
    private JdbcDataSourceService jdbsDataSourceService;
    private Connection dbConnection;

    public SwitchingDataSource(RepositoryService repositoryService, BeanForInterfaceImplementationFactory dataSourceService) {
        LOG.debug((Object)"creating SwitchingDataSource");
        if (repositoryService == null) {
            LOG.fatal((Object)"repositoryService is null");
        }
        if (dataSourceService == null) {
            LOG.fatal((Object)"dataSourceService is null");
        }
        this.repositoryService = repositoryService;
        this.dataSourceService = dataSourceService;
    }

    public void setReportParameterValues(Map parameterValues) {
        if (LOG.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            sw.append("incoming parameter values:\n");
            for (Object key : parameterValues.keySet()) {
                sw.append('\t').append(key.toString()).append(":\t\t");
                Object value = parameterValues.get(key);
                if (value == null) {
                    sw.append("null");
                } else {
                    sw.append(value.toString());
                }
                sw.append('\n');
            }
            LOG.trace((Object)sw.toString());
        }
        LOG.debug((Object)"injecting client-specific data source");
        AuthToken token = AuthTokenAuthenticationUtil.getCurrentAuthToken();
        String client = null;
        if (token == null) {
            LOG.warn((Object)"authentication token not found, not setting a data source");
            return;
        }
        client = token.getCredentialField("client");
        LOG.debug((Object)("finding datasource for client:" + client));
        client = client.replace('-', '_');
        String dataSourceURI = "/rSmart/" + client;
        this.jdbsDataSourceService = this.getRepositoryDatasource(dataSourceURI);
        try {
            LOG.debug((Object)"setting connection parameter for report");
            this.dbConnection = this.jdbsDataSourceService.getDataSource().getConnection();
            parameterValues.put("REPORT_CONNECTION", this.dbConnection);
        }
        catch (SQLException sqle) {
            LOG.error((Object)"SQLException encountered while getting connection for report", (Throwable)sqle);
            throw new RuntimeException("Error obtaining DB connection for client", sqle);
        }
    }

    protected JdbcDataSourceService getRepositoryDatasource(String repositoryURI) {
        LOG.debug((Object)("getting pre-configured repository datasource: " + repositoryURI));
        ExecutionContext context = JasperServerUtil.getExecutionContext((Locale)LocaleContextHolder.getLocale());
        ReportDataSource datasource = (ReportDataSource)this.repositoryService.getResource(context, repositoryURI);
        if (datasource == null) {
            LOG.error((Object)("Could not find resource at: " + repositoryURI));
            return null;
        }
        JdbcReportDataSourceServiceFactory factory = (JdbcReportDataSourceServiceFactory)this.dataSourceService.getBean(datasource.getClass());
        JdbcDataSourceService DSservice = (JdbcDataSourceService)factory.createService(datasource);
        return DSservice;
    }

    public void closeConnection() {
        LOG.debug((Object)"closeConnection()");
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (Exception e) {
                LOG.error((Object)"unexpected exception while closing database connection");
            }
        }
        if (this.jdbsDataSourceService != null) {
            LOG.debug((Object)"closing connection");
            this.jdbsDataSourceService.closeConnection();
        } else {
            LOG.debug((Object)"no connection to close");
            try {
                throw new Exception("this is thrown solely to get a stacktrace");
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                sw.flush();
                LOG.debug((Object)sw.toString());
            }
        }
    }
}

