/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.jasperreports.datasource;

import com.jaspersoft.jasperserver.api.common.service.BeanForInterfaceImplementationFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcDataSourceService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.rsmart.rfabric.jasperreports.datasource.ClientDataSourceService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.context.SecurityContextHolder;

public class MultiClientDataSourceService
extends JdbcDataSourceService {
    private static final Log LOG = LogFactory.getLog(MultiClientDataSourceService.class);
    protected BeanForInterfaceImplementationFactory dataSourceServiceFactories;
    protected ClientDataSourceService clientDataSourceService;
    protected JdbcDataSourceService jdbcDataSourceService;
    protected Connection dbConnection;

    public MultiClientDataSourceService(DataSource dataSource, TimeZone timezone) {
        super(dataSource, timezone);
    }

    public void setDataSourceServiceFactories(BeanForInterfaceImplementationFactory dataSourceServiceFactories) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("setDataSourceServiceFactories(BeanForInterfaceImplementationFactory " + dataSourceServiceFactories + ")"));
        }
        this.dataSourceServiceFactories = dataSourceServiceFactories;
    }

    public void setReportParameterValues(Map parameterValues) {
        User user;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("setReportParameterValues(Map " + parameterValues + ")"));
        }
        if ((user = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal()) != null) {
            String tenantId = null;
            tenantId = user.getTenantId();
            if (tenantId != null) {
                LOG.trace((Object)(user.getUsername() + " maps to Jasper Enterprise Organization: " + tenantId));
            } else {
                for (Object iterable_element : user.getAttributes()) {
                    ProfileAttribute attribute = (ProfileAttribute)iterable_element;
                    if (!"TENANT".equalsIgnoreCase(attribute.getAttrName())) continue;
                    tenantId = attribute.getAttrValue();
                }
            }
            if (tenantId != null) {
                LOG.trace((Object)(user.getUsername() + " maps to poor man's tenant: " + tenantId));
                this.jdbcDataSourceService = this.getRepositoryDatasource(tenantId);
                if (this.jdbcDataSourceService != null) {
                    try {
                        this.dbConnection = this.jdbcDataSourceService.getDataSource().getConnection();
                        parameterValues.put("REPORT_CONNECTION", this.dbConnection);
                    }
                    catch (SQLException sqle) {
                        LOG.error((Object)"Failed to set connection parameter", (Throwable)sqle);
                        throw new RuntimeException("Failed to set connection parameter", sqle);
                    }
                } else {
                    LOG.warn((Object)("No connection found for tenantId: " + tenantId));
                }
            } else {
                LOG.error((Object)("Could not determine tenantId for user: " + user.getUsername()));
            }
        } else {
            LOG.trace((Object)"User object is null!");
        }
    }

    public void closeConnection() {
        try {
            if (this.dbConnection != null) {
                this.dbConnection.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"unexpected error closing DB connection", (Throwable)e);
        }
        if (this.jdbcDataSourceService != null) {
            this.jdbcDataSourceService.closeConnection();
        }
    }

    public JdbcDataSourceService getRepositoryDatasource(String tenant) {
        JdbcReportDataSource datasource = this.getClientDataSourceService().getDataSourceServiceForClient(tenant);
        if (this.dataSourceServiceFactories == null) {
            LOG.fatal((Object)"no data source service set");
            throw new IllegalStateException("no data source service set");
        }
        JdbcReportDataSourceServiceFactory factory = (JdbcReportDataSourceServiceFactory)this.dataSourceServiceFactories.getBean(JdbcReportDataSource.class);
        return (JdbcDataSourceService)factory.createService((ReportDataSource)datasource);
    }

    public ClientDataSourceService getClientDataSourceService() {
        return this.clientDataSourceService;
    }

    public void setClientDataSourceService(ClientDataSourceService clientDataSourceService) {
        this.clientDataSourceService = clientDataSourceService;
    }

    protected Connection createConnection() {
        LOG.trace((Object)"createConnection()");
        try {
            this.dbConnection = this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.dbConnection;
    }

    public DataSource getDataSource() {
        User user = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (user != null) {
            String tenantId = null;
            tenantId = user.getTenantId();
            if (tenantId != null) {
                LOG.trace((Object)(user.getUsername() + " maps to Jasper Enterprise Organization: " + tenantId));
            } else {
                for (Object iterable_element : user.getAttributes()) {
                    ProfileAttribute attribute = (ProfileAttribute)iterable_element;
                    if (!"TENANT".equalsIgnoreCase(attribute.getAttrName())) continue;
                    tenantId = attribute.getAttrValue();
                }
            }
            if (tenantId != null) {
                LOG.trace((Object)(user.getUsername() + " maps to poor man's tenant: " + tenantId));
                this.jdbcDataSourceService = this.getRepositoryDatasource(tenantId);
                if (this.jdbcDataSourceService != null) {
                    return this.jdbcDataSourceService.getDataSource();
                }
                LOG.warn((Object)("No connection found for tenantId: " + tenantId));
            } else {
                LOG.error((Object)("Could not determine tenantId for user: " + user.getUsername()));
            }
        } else {
            LOG.trace((Object)"User object is null!");
        }
        return null;
    }
}

