package com.rsmart.kuali.coeus.hr.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * This adapter ensures that parsing exceptions are logged.
 * 
 * @author duffy
 *
 */
public class HRImportValidationErrorHandler implements ErrorHandler {
  private static final Logger LOG = LoggerFactory.getLogger(HRImportValidationErrorHandler.class);

  public void warning(SAXParseException exception) throws SAXException {
    LOG.warn(exception.getMessage(), exception);
  }

  public void error(SAXParseException exception) throws SAXException {
    LOG.error(exception.getMessage(), exception);
  }

  public void fatalError(SAXParseException exception) throws SAXException {
    LOG.error(exception.getMessage(), exception);
  }

}
