/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.kuali.coeus.hr.rest;

import com.rsmart.kuali.coeus.hr.rest.model.DOMHRImport;
import com.rsmart.kuali.coeus.hr.rest.model.HRImport;
import com.rsmart.kuali.coeus.hr.service.HRImportService;
import com.rsmart.kuali.coeus.hr.service.ImportError;
import com.rsmart.kuali.coeus.hr.service.ImportRunner;
import com.rsmart.kuali.coeus.hr.service.ImportStatus;
import com.rsmart.kuali.coeus.hr.service.ImportStatusService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="hrimport")
public class HRImportResource {
    private static final Logger LOG = LoggerFactory.getLogger(HRImportResource.class);
    public static final String SCHEMA_PATH = "/hrmanifest.xsd";
    public static final String IMPORT_SERVICE_NAME = "hrImportService";
    public static final String HR_IMPORT_IN_MEMORY = "hrimport.inMemory";
    protected transient HRImportService importService = null;
    protected transient ImportRunner importRunner = null;
    protected transient ImportStatusService statusService = null;
    protected transient JAXBContext jaxbContext = null;
    protected transient Schema hrImportSchema = null;
    protected transient Unmarshaller hrImportUnmarshaller = null;

    public HRImportResource() throws Exception {
        LOG.info("HRImportResource created");
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DOMHRImport.class});
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.hrImportSchema = sf.newSchema(new StreamSource(this.getClass().getResourceAsStream(SCHEMA_PATH)));
        LOG.debug("schema loaded from /hrmanifest.xsd");
        this.hrImportUnmarshaller = this.jaxbContext.createUnmarshaller();
        this.hrImportUnmarshaller.setSchema(this.hrImportSchema);
    }

    public String statusToJson(ImportStatus status) {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append("\"importId\":\"").append(status.getImportId()).append("\",");
        sb.append("\"status\":\"").append((Object)status.getStatus()).append("\",");
        String msg = status.getMessage();
        if (msg != null) {
            sb.append("\"message\":\"").append(msg).append("\",");
        }
        sb.append("\"startTime\":\"").append(status.getStartTimeInMillis()).append("\",");
        long end = status.getEndTimeInMillis();
        if (end > 0L) {
            sb.append("\"endTime\":\"").append(end).append("\",");
        }
        sb.append("\"recordTotal\":\"").append(status.getRecordTotal()).append("\",");
        sb.append("\"processedRecords\":\"").append(status.getProcessedRecordCount()).append("\",");
        int errorCount = status.getErrorCount();
        sb.append("\"errorCount\":\"").append(errorCount).append("\"");
        if (errorCount > 0) {
            sb.append(",\"errors\":[");
            List<ImportError> errors = status.getErrors();
            String separator = "";
            for (ImportError error : errors) {
                sb.append(separator);
                separator = ",";
                sb.append("{\"recordNumber\":\"").append(error.getRecordNumber()).append("\",");
                sb.append("\"principalName\":\"").append(error.getPrincipalName()).append("\",");
                Exception e = error.getException();
                sb.append("\"exception\":{\"type\":\"").append(e.getClass().getSimpleName()).append("\",");
                sb.append("\"message\":\"").append(e.getMessage()).append("\"}}");
            }
            sb.append(']');
        }
        sb.append('}');
        return sb.toString();
    }

    protected final boolean runInMemory() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty(HR_IMPORT_IN_MEMORY, false);
    }

    @POST
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    public Response processImport(@FormDataParam(value="file") InputStream uploadedInputStream) throws Exception {
        Response res;
        if (uploadedInputStream == null) {
            LOG.error("import called without file argument");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        File tempFile = File.createTempFile("hrimport", Long.toString(new Date().getTime()));
        LOG.debug("writing uploaded HR import to : " + tempFile.getAbsolutePath());
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            int read = 0;
            byte[] bytes = new byte[32768];
            while ((read = uploadedInputStream.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            LOG.error("Error while processing an hrimport file upload", (Throwable)e);
            throw e;
        }
        String importId = UUID.randomUUID().toString();
        LOG.debug("initiating import with ID: " + importId);
        try {
            ImportRunner runner = this.getImportRunner();
            ImportStatus status = null;
            if (this.runInMemory()) {
                HRImport toImport = (HRImport)this.hrImportUnmarshaller.unmarshal(tempFile);
                status = runner.processImport(importId, toImport);
            } else {
                status = runner.processImport(importId, tempFile.getAbsolutePath());
            }
            res = Response.ok().entity((Object)this.statusToJson(status)).build();
        }
        catch (Exception e) {
            res = Response.noContent().status(500).build();
            LOG.error("Import failed ", (Throwable)e);
        }
        return res;
    }

    @DELETE
    @Path(value="/import/{importId}")
    public Response abort(@PathParam(value="importId") String importId) {
        Response res;
        try {
            ImportRunner runner = this.getImportRunner();
            runner.abort(importId);
            res = Response.ok().build();
        }
        catch (Exception e) {
            res = Response.noContent().status(500).build();
        }
        return res;
    }

    @GET
    @Path(value="/import/{importId}")
    public Response status(@PathParam(value="importId") String importId) {
        Response res;
        try {
            ImportStatus status = this.getStatusService().getImportStatus(importId);
            res = status == null ? Response.noContent().status(Response.Status.NOT_FOUND).build() : Response.ok().entity((Object)this.statusToJson(status)).build();
        }
        catch (Exception e) {
            res = Response.noContent().status(500).build();
        }
        return res;
    }

    @DELETE
    @Path(value="/delete/{entityId}")
    public Response deleteRecord(@PathParam(value="entityId") String entityId) {
        try {
            this.getImportService().deletePerson(entityId);
        }
        catch (Exception e) {
            return Response.status((int)500).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/principals/unmanaged")
    public Response unmanagedPrincipals() {
        try {
            List<String> names = this.getStatusService().getPrincipalNamesUnmanagedByHRImport();
            StringBuilder sb = new StringBuilder();
            boolean comma = false;
            sb.append('[');
            for (String name : names) {
                if (comma) {
                    sb.append(',');
                }
                comma = true;
                sb.append('\"').append(name).append('\"');
            }
            sb.append(']');
            return Response.ok((Object)sb.toString()).build();
        }
        catch (Exception e) {
            return Response.status((int)500).build();
        }
    }

    public HRImportService getImportService() {
        if (this.importService == null) {
            this.importService = (HRImportService)KcServiceLocator.getService((String)IMPORT_SERVICE_NAME);
        }
        return this.importService;
    }

    public void setImportService(HRImportService importService) {
        this.importService = importService;
    }

    public ImportStatusService getStatusService() {
        if (this.statusService == null) {
            this.statusService = (ImportStatusService)KcServiceLocator.getService((String)"importStatusService");
        }
        return this.statusService;
    }

    public void setStatusService(ImportStatusService svc) {
        this.statusService = svc;
    }

    public ImportRunner getImportRunner() {
        if (this.importRunner == null) {
            this.importRunner = (ImportRunner)KcServiceLocator.getService((String)"importRunner");
        }
        return this.importRunner;
    }

    public void setImportRunner(ImportRunner runner) {
        this.importRunner = runner;
    }
}

