/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.Values;

import com.shapesecurity.salvation2.Constants;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;

public class MediaType {
    @Nonnull
    public final String type;
    @Nonnull
    public final String subtype;

    private MediaType(String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
    }

    public static Optional<MediaType> parseMediaType(String value) {
        Matcher matcher = Constants.mediaTypePattern.matcher(value);
        if (matcher.find()) {
            String type = matcher.group("type").toLowerCase(Locale.ENGLISH);
            String subtype = matcher.group("subtype").toLowerCase(Locale.ENGLISH);
            return Optional.of(new MediaType(type, subtype));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return this.type.equals(mediaType.type) && this.subtype.equals(mediaType.subtype);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype);
    }

    public String toString() {
        return this.type + "/" + this.subtype;
    }
}

