/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class FilterArgument
extends Argument {
    private static final long serialVersionUID = -1889200072476038957L;
    private final ArrayList<Filter> values;
    private final List<ArgumentValueValidator> validators;
    private final List<Filter> defaultValues;

    public FilterArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, (List<Filter>)null);
    }

    public FilterArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, Filter defaultValue) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, defaultValue == null ? null : Arrays.asList(defaultValue));
    }

    public FilterArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, List<Filter> defaultValues) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description);
        if (valuePlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MUST_TAKE_VALUE.get(this.getIdentifierString()));
        }
        this.defaultValues = defaultValues == null || defaultValues.isEmpty() ? null : Collections.unmodifiableList(defaultValues);
        this.values = new ArrayList(5);
        this.validators = new ArrayList<ArgumentValueValidator>(5);
    }

    private FilterArgument(FilterArgument source) {
        super(source);
        this.defaultValues = source.defaultValues;
        this.validators = new ArrayList<ArgumentValueValidator>(source.validators);
        this.values = new ArrayList(5);
    }

    public List<Filter> getDefaultValues() {
        return this.defaultValues;
    }

    public void addValueValidator(ArgumentValueValidator validator) {
        this.validators.add(validator);
    }

    @Override
    protected void addValue(String valueString) throws ArgumentException {
        Filter filter;
        try {
            filter = Filter.create(valueString);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new ArgumentException(ArgsMessages.ERR_FILTER_VALUE_NOT_FILTER.get(valueString, this.getIdentifierString(), le.getMessage()), le);
        }
        if (this.values.size() >= this.getMaxOccurrences()) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        for (ArgumentValueValidator v : this.validators) {
            v.validateArgumentValue(this, valueString);
        }
        this.values.add(filter);
    }

    public Filter getValue() {
        if (this.values.isEmpty()) {
            if (this.defaultValues == null || this.defaultValues.isEmpty()) {
                return null;
            }
            return this.defaultValues.get(0);
        }
        return this.values.get(0);
    }

    public List<Filter> getValues() {
        if (this.values.isEmpty() && this.defaultValues != null) {
            return this.defaultValues;
        }
        return Collections.unmodifiableList(this.values);
    }

    @Override
    protected boolean hasDefaultValue() {
        return this.defaultValues != null && !this.defaultValues.isEmpty();
    }

    @Override
    public String getDataTypeName() {
        return ArgsMessages.INFO_FILTER_TYPE_NAME.get();
    }

    @Override
    public String getValueConstraints() {
        return ArgsMessages.INFO_FILTER_CONSTRAINTS.get();
    }

    @Override
    public FilterArgument getCleanCopy() {
        return new FilterArgument(this);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("FilterArgument(");
        this.appendBasicToStringInfo(buffer);
        if (this.defaultValues != null && !this.defaultValues.isEmpty()) {
            if (this.defaultValues.size() == 1) {
                buffer.append(", defaultValue='");
                buffer.append(this.defaultValues.get(0).toString());
            } else {
                buffer.append(", defaultValues={");
                Iterator<Filter> iterator = this.defaultValues.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next().toString());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
            }
        }
        buffer.append(')');
    }
}

