/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.core.util;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.core.util.Pool;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ThreadSafeSimpleDateFormat {
    private final String formatString;
    private final Pool pool;

    public ThreadSafeSimpleDateFormat(String format, int initialPoolSize, int maxPoolSize, final boolean lenient) {
        this.formatString = format;
        this.pool = new Pool(initialPoolSize, maxPoolSize, new Pool.Factory(){

            @Override
            public Object newInstance() {
                SimpleDateFormat dateFormat = new SimpleDateFormat(ThreadSafeSimpleDateFormat.this.formatString, Locale.ENGLISH);
                dateFormat.setLenient(lenient);
                return dateFormat;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date) {
        DateFormat format = this.fetchFromPool();
        try {
            String string = format.format(date);
            return string;
        }
        finally {
            this.pool.putInPool(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String date) throws ParseException {
        DateFormat format = this.fetchFromPool();
        try {
            Date date2 = format.parse(date);
            return date2;
        }
        finally {
            this.pool.putInPool(format);
        }
    }

    private DateFormat fetchFromPool() {
        DateFormat format;
        TimeZone tz = TimeZone.getDefault();
        if (!tz.equals((format = (DateFormat)this.pool.fetchFromPool()).getTimeZone())) {
            format.setTimeZone(tz);
        }
        return format;
    }
}

