/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.WsMemberFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembershipsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetMembershipsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcGetMemberships {
    private String wsEndpoint;
    private String wsUser;
    private String wsPass;
    private String enabled;
    private Set<WsSubjectLookup> wsSubjectLookups = new LinkedHashSet<WsSubjectLookup>();
    private String stemScope = null;
    private WsStemLookup wsStemLookup = null;
    private String clientVersion;
    private Set<String> groupNames = new LinkedHashSet<String>();
    private Set<String> groupUuids = new LinkedHashSet<String>();
    private Set<String> ownerNamesOfAttributeDefs = new LinkedHashSet<String>();
    private Set<String> ownerUuidsOfAttributeDefs = new LinkedHashSet<String>();
    private Set<String> ownerStemNames = new LinkedHashSet<String>();
    private Set<String> ownerStemUuids = new LinkedHashSet<String>();
    private Set<Long> groupIdIndexes = new LinkedHashSet<Long>();
    private Integer pageSize;
    private Integer pageNumber;
    private String sortString;
    private Boolean ascending;
    private Integer pageSizeForMember;
    private Integer pageNumberForMember;
    private String sortStringForMember;
    private Boolean ascendingForMember;
    private Boolean pageIsCursor;
    private String pageLastCursorField;
    private String pageLastCursorFieldType;
    private Boolean pageCursorFieldIncludesLastRetrieved;
    private Boolean pageIsCursorForMember;
    private String pageLastCursorFieldForMember;
    private String pageLastCursorFieldTypeForMember;
    private Boolean pageCursorFieldIncludesLastRetrievedForMember;
    private Boolean pointInTimeRetrieve;
    private Timestamp pointInTimeFrom;
    private Timestamp pointInTimeTo;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsMemberFilter memberFilter;
    private WsSubjectLookup actAsSubject;
    private String fieldName;
    private String fieldType;
    private String scope;
    private String serviceRole;
    private WsAttributeDefNameLookup serviceLookup;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private Set<String> sourceIds = null;
    private Set<String> membershipIds = null;

    public GcGetMemberships assignWsEndpoint(String theWsEndpoint) {
        this.wsEndpoint = theWsEndpoint;
        return this;
    }

    public GcGetMemberships assignWsUser(String theWsUser) {
        this.wsUser = theWsUser;
        return this;
    }

    public GcGetMemberships assignWsPass(String theWsPass) {
        this.wsPass = theWsPass;
        return this;
    }

    public GcGetMemberships assignWsPassEncrypted(String theWsPassEncrypted) {
        String encryptKey = GrouperClientUtils.encryptKey();
        return this.assignWsPass(new Crypto(encryptKey).decrypt(theWsPassEncrypted));
    }

    public GcGetMemberships assignWsPassFile(File theFile) {
        return this.assignWsPass(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcGetMemberships assignWsPassFileEncrypted(File theFile) {
        return this.assignWsPassEncrypted(GrouperClientUtils.readFileIntoString(theFile));
    }

    public GcGetMemberships assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGetMemberships assignWsStem(WsStemLookup theWsStemLookup) {
        this.wsStemLookup = theWsStemLookup;
        return this;
    }

    public GcGetMemberships assignPageSize(Integer thePageSize) {
        this.pageSize = thePageSize;
        return this;
    }

    public GcGetMemberships assignPageNumber(Integer thePageNumber) {
        this.pageNumber = thePageNumber;
        return this;
    }

    public GcGetMemberships assignSortString(String theSortString) {
        this.sortString = theSortString;
        return this;
    }

    public GcGetMemberships assignAscending(Boolean theAscending) {
        this.ascending = theAscending;
        return this;
    }

    public GcGetMemberships assignPageSizeForMember(Integer thePageSizeForMember) {
        this.pageSizeForMember = thePageSizeForMember;
        return this;
    }

    public GcGetMemberships assignPageNumberForMember(Integer thePageNumberForMember) {
        this.pageNumberForMember = thePageNumberForMember;
        return this;
    }

    public GcGetMemberships assignSortStringForMember(String theSortStringForMember) {
        this.sortStringForMember = theSortStringForMember;
        return this;
    }

    public GcGetMemberships assignAscendingForMember(Boolean theAscendingForMember) {
        this.ascendingForMember = theAscendingForMember;
        return this;
    }

    public GcGetMemberships assignPageIsCursor(Boolean pageIsCursor) {
        this.pageIsCursor = pageIsCursor;
        return this;
    }

    public GcGetMemberships assignPageLastCursorField(String pageLastCursorField) {
        this.pageLastCursorField = pageLastCursorField;
        return this;
    }

    public GcGetMemberships assignPageLastCursorFieldType(String pageLastCursorFieldType) {
        this.pageLastCursorFieldType = pageLastCursorFieldType;
        return this;
    }

    public GcGetMemberships assignPageCursorFieldIncludesLastRetrieved(Boolean pageCursorFieldIncludesLastRetrieved) {
        this.pageCursorFieldIncludesLastRetrieved = pageCursorFieldIncludesLastRetrieved;
        return this;
    }

    public GcGetMemberships assignPageIsCursorForMember(Boolean pageIsCursorForMember) {
        this.pageIsCursorForMember = pageIsCursorForMember;
        return this;
    }

    public GcGetMemberships assignPageLastCursorFieldForMember(String pageLastCursorFieldForMember) {
        this.pageLastCursorFieldForMember = pageLastCursorFieldForMember;
        return this;
    }

    public GcGetMemberships assignPageLastCursorFieldTypeForMember(String pageLastCursorFieldTypeForMember) {
        this.pageLastCursorFieldTypeForMember = pageLastCursorFieldTypeForMember;
        return this;
    }

    public GcGetMemberships assignPageCursorFieldIncludesLastRetrievedForMember(Boolean pageCursorFieldIncludesLastRetrievedForMember) {
        this.pageCursorFieldIncludesLastRetrievedForMember = pageCursorFieldIncludesLastRetrievedForMember;
        return this;
    }

    public GcGetMemberships assignPointInTimeRetrieve(Boolean pointInTimeRetrieve) {
        this.pointInTimeRetrieve = pointInTimeRetrieve;
        return this;
    }

    public GcGetMemberships assignPointInTimeFrom(Timestamp pointInTimeFrom) {
        this.pointInTimeFrom = pointInTimeFrom;
        return this;
    }

    public GcGetMemberships assignPointInTimeTo(Timestamp pointInTimeTo) {
        this.pointInTimeTo = pointInTimeTo;
        return this;
    }

    public GcGetMemberships addGroupName(String theGroupName) {
        this.groupNames.add(theGroupName);
        return this;
    }

    public GcGetMemberships addGroupIdIndex(Long theGroupIdIndex) {
        this.groupIdIndexes.add(theGroupIdIndex);
        return this;
    }

    public GcGetMemberships addOwnerStemName(String theOwnerStemName) {
        this.ownerStemNames.add(theOwnerStemName);
        return this;
    }

    public GcGetMemberships addOwnerStemUuid(String theOwnerStemUuid) {
        this.ownerStemUuids.add(theOwnerStemUuid);
        return this;
    }

    public GcGetMemberships addOwnerNameOfAttributeDef(String theOwnerNameOfAttributeDef) {
        this.ownerNamesOfAttributeDefs.add(theOwnerNameOfAttributeDef);
        return this;
    }

    public GcGetMemberships addOwnerUuidOfAttributeDef(String theOwnerUuidOfAttributeDef) {
        this.ownerUuidsOfAttributeDefs.add(theOwnerUuidOfAttributeDef);
        return this;
    }

    public GcGetMemberships addWsSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.wsSubjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcGetMemberships addGroupUuid(String theGroupUuid) {
        this.groupUuids.add(theGroupUuid);
        return this;
    }

    public GcGetMemberships addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetMemberships addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetMemberships assignMemberFilter(WsMemberFilter theMemberFilter) {
        this.memberFilter = theMemberFilter;
        return this;
    }

    public GcGetMemberships assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.groupNames) == 0 && GrouperClientUtils.length(this.groupUuids) == 0 && GrouperClientUtils.length(this.ownerStemNames) == 0 && GrouperClientUtils.length(this.ownerStemUuids) == 0 && GrouperClientUtils.length(this.ownerNamesOfAttributeDefs) == 0 && GrouperClientUtils.length(this.ownerUuidsOfAttributeDefs) == 0 && GrouperClientUtils.length(this.groupIdIndexes) == 0 && GrouperClientUtils.length(this.membershipIds) == 0 && GrouperClientUtils.length(this.wsSubjectLookups) == 0 && GrouperClientUtils.isBlank(this.serviceRole) && this.wsStemLookup == null) {
            throw new RuntimeException("Group name or uuid or id index or subject lookup or membership id or owner stem uuid or name or owner uuid or name of attribute def or serviceRole or stem lookup is required: " + this);
        }
        if (GrouperClientUtils.isBlank(this.serviceRole) != (this.serviceLookup == null || GrouperClientUtils.isBlank(this.serviceLookup.getIdIndex()) && GrouperClientUtils.isBlank(this.serviceLookup.getName()) && GrouperClientUtils.isBlank(this.serviceLookup.getUuid()))) {
            throw new RuntimeException("If serviceRole is passed in, then a serviceId or serviceName needs to be passed in");
        }
    }

    public GcGetMemberships assignFieldType(String fieldType1) {
        this.fieldType = fieldType1;
        return this;
    }

    public GcGetMemberships assignServiceLookup(WsAttributeDefNameLookup serviceLookup1) {
        this.serviceLookup = serviceLookup1;
        return this;
    }

    public GcGetMemberships assignServiceRole(String serviceRole1) {
        this.serviceRole = serviceRole1;
        return this;
    }

    public GcGetMemberships assignFieldName(String theFieldName) {
        this.fieldName = theFieldName;
        return this;
    }

    public GcGetMemberships assignScope(String theScope) {
        this.scope = theScope;
        return this;
    }

    public GcGetMemberships addSourceId(String sourceId) {
        if (this.sourceIds == null) {
            this.sourceIds = new LinkedHashSet<String>();
        }
        this.sourceIds.add(sourceId);
        return this;
    }

    public GcGetMemberships addMembershipId(String sourceId) {
        if (this.membershipIds == null) {
            this.membershipIds = new LinkedHashSet<String>();
        }
        this.membershipIds.add(sourceId);
        return this;
    }

    public GcGetMemberships addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcGetMemberships assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcGetMemberships assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsGetMembershipsResults execute() {
        this.validate();
        WsGetMembershipsResults wsGetMembershipsResults = null;
        try {
            WsRestGetMembershipsRequest getMemberships = new WsRestGetMembershipsRequest();
            getMemberships.setActAsSubjectLookup(this.actAsSubject);
            getMemberships.setEnabled(this.enabled);
            getMemberships.setFieldName(this.fieldName);
            getMemberships.setFieldType(this.fieldType);
            ArrayList<WsGroupLookup> groupLookups = new ArrayList<WsGroupLookup>();
            for (String groupName : this.groupNames) {
                groupLookups.add(new WsGroupLookup(groupName, null));
            }
            for (String groupUuid : this.groupUuids) {
                groupLookups.add(new WsGroupLookup(null, groupUuid));
            }
            for (Long groupIdIndex : this.groupIdIndexes) {
                groupLookups.add(new WsGroupLookup(null, null, groupIdIndex.toString()));
            }
            if (GrouperClientUtils.length(groupLookups) > 0) {
                getMemberships.setWsGroupLookups(GrouperClientUtils.toArray(groupLookups, WsGroupLookup.class));
            }
            ArrayList<WsStemLookup> ownerStemLookups = new ArrayList<WsStemLookup>();
            for (String ownerStemName : this.ownerStemNames) {
                ownerStemLookups.add(new WsStemLookup(ownerStemName, null));
            }
            for (String ownerStemUuid : this.ownerStemUuids) {
                ownerStemLookups.add(new WsStemLookup(null, ownerStemUuid));
            }
            if (GrouperClientUtils.length(ownerStemLookups) > 0) {
                getMemberships.setWsOwnerStemLookups(GrouperClientUtils.toArray(ownerStemLookups, WsStemLookup.class));
            }
            ArrayList<WsAttributeDefLookup> ownerAttributeDefLookups = new ArrayList<WsAttributeDefLookup>();
            for (String ownerNameOfAttributeDef : this.ownerNamesOfAttributeDefs) {
                ownerAttributeDefLookups.add(new WsAttributeDefLookup(ownerNameOfAttributeDef, null));
            }
            for (String ownerUuidOfAttributeDef : this.ownerUuidsOfAttributeDefs) {
                ownerAttributeDefLookups.add(new WsAttributeDefLookup(null, ownerUuidOfAttributeDef));
            }
            if (GrouperClientUtils.length(ownerAttributeDefLookups) > 0) {
                getMemberships.setWsOwnerAttributeDefLookups(GrouperClientUtils.toArray(ownerAttributeDefLookups, WsAttributeDefLookup.class));
            }
            if (this.includeGroupDetail != null) {
                getMemberships.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                getMemberships.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            if (this.serviceLookup != null) {
                getMemberships.setServiceLookup(this.serviceLookup);
            }
            if (this.serviceRole != null) {
                getMemberships.setServiceRole(this.serviceRole);
            }
            getMemberships.setMemberFilter(this.memberFilter == null ? null : this.memberFilter.name());
            if (GrouperClientUtils.length(this.membershipIds) > 0) {
                getMemberships.setMembershipIds(GrouperClientUtils.toArray(this.membershipIds, String.class));
            }
            if (this.params.size() > 0) {
                getMemberships.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            getMemberships.setScope(this.scope);
            if (this.pageSize != null) {
                getMemberships.setPageSize(this.pageSize.toString());
            }
            if (this.pageNumber != null) {
                getMemberships.setPageNumber(this.pageNumber.toString());
            }
            getMemberships.setSortString(this.sortString);
            if (this.ascending != null) {
                getMemberships.setAscending(this.ascending != false ? "T" : "F");
            }
            if (this.pageSizeForMember != null) {
                getMemberships.setPageSizeForMember(this.pageSizeForMember.toString());
            }
            if (this.pageNumberForMember != null) {
                getMemberships.setPageNumberForMember(this.pageNumberForMember.toString());
            }
            getMemberships.setSortStringForMember(this.sortStringForMember);
            if (this.ascendingForMember != null) {
                getMemberships.setAscendingForMember(this.ascendingForMember != false ? "T" : "F");
            }
            if (GrouperClientUtils.length(this.sourceIds) > 0) {
                getMemberships.setSourceIds(GrouperClientUtils.toArray(this.sourceIds, String.class));
            }
            getMemberships.setStemScope(this.stemScope);
            if (this.subjectAttributeNames.size() > 0) {
                getMemberships.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            getMemberships.setWsStemLookup(this.wsStemLookup);
            if (GrouperClientUtils.length(this.wsSubjectLookups) > 0) {
                getMemberships.setWsSubjectLookups(GrouperClientUtils.toArray(this.wsSubjectLookups, WsSubjectLookup.class));
            }
            if (this.pointInTimeRetrieve != null) {
                getMemberships.setPointInTimeRetrieve(this.pointInTimeRetrieve != false ? "T" : "F");
            }
            getMemberships.setPointInTimeFrom(GrouperClientUtils.dateToString(this.pointInTimeFrom));
            getMemberships.setPointInTimeTo(GrouperClientUtils.dateToString(this.pointInTimeTo));
            if (this.pageIsCursor != null) {
                getMemberships.setPageIsCursor(this.pageIsCursor != false ? "T" : "F");
            }
            if (this.pageCursorFieldIncludesLastRetrieved != null) {
                getMemberships.setPageCursorFieldIncludesLastRetrieved(this.pageCursorFieldIncludesLastRetrieved != false ? "T" : "F");
            }
            getMemberships.setPageLastCursorField(this.pageLastCursorField);
            getMemberships.setPageLastCursorFieldType(this.pageLastCursorFieldType);
            if (this.pageIsCursorForMember != null) {
                getMemberships.setPageIsCursorForMember(this.pageIsCursorForMember != false ? "T" : "F");
            }
            if (this.pageCursorFieldIncludesLastRetrievedForMember != null) {
                getMemberships.setPageCursorFieldIncludesLastRetrievedForMember(this.pageCursorFieldIncludesLastRetrievedForMember != false ? "T" : "F");
            }
            getMemberships.setPageLastCursorFieldForMember(this.pageLastCursorFieldForMember);
            getMemberships.setPageLastCursorFieldTypeForMember(this.pageLastCursorFieldTypeForMember);
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            grouperClientWs.assignWsUser(this.wsUser);
            grouperClientWs.assignWsPass(this.wsPass);
            grouperClientWs.assignWsEndpoint(this.wsEndpoint);
            wsGetMembershipsResults = (WsGetMembershipsResults)grouperClientWs.executeService("memberships", getMemberships, "getMemberships", this.clientVersion, true);
            String resultMessage = wsGetMembershipsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetMembershipsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetMembershipsResults;
    }

    @Deprecated
    public GcGetMemberships assigStemScope(String theStemScope) {
        return this.assignStemScope(theStemScope);
    }

    public GcGetMemberships assignStemScope(String theStemScope) {
        this.stemScope = theStemScope;
        return this;
    }

    public GcGetMemberships assignEnabled(String theEnabled) {
        this.enabled = theEnabled;
        return this;
    }
}

