/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.methods;

import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.Header;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpConnection;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpMethodBase;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpState;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class OptionsMethod
extends HttpMethodBase {
    private static final Log LOG = LogFactory.getLog(OptionsMethod.class);
    private Vector methodsAllowed = new Vector();

    public OptionsMethod() {
    }

    public OptionsMethod(String uri) {
        super(uri);
    }

    @Override
    public String getName() {
        return "OPTIONS";
    }

    public boolean isAllowed(String method) {
        this.checkUsed();
        return this.methodsAllowed.contains(method);
    }

    public Enumeration getAllowedMethods() {
        this.checkUsed();
        return this.methodsAllowed.elements();
    }

    @Override
    protected void processResponseHeaders(HttpState state, HttpConnection conn) {
        LOG.trace("enter OptionsMethod.processResponseHeaders(HttpState, HttpConnection)");
        Header allowHeader = this.getResponseHeader("allow");
        if (allowHeader != null) {
            String allowHeaderValue = allowHeader.getValue();
            StringTokenizer tokenizer = new StringTokenizer(allowHeaderValue, ",");
            while (tokenizer.hasMoreElements()) {
                String methodAllowed = tokenizer.nextToken().trim().toUpperCase();
                this.methodsAllowed.addElement(methodAllowed);
            }
        }
    }

    public boolean needContentLength() {
        return false;
    }
}

