/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.props.LdapConfigPropertyInvoker;
import edu.vt.middleware.ldap.props.LdapProperties;
import edu.vt.middleware.ldap.props.PropertyConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCli {
    protected static final String OPT_HELP = "help";
    protected static final String OPT_TRACE = "trace";
    protected static final String OPT_USE_PROPERTIES = "useProperties";
    protected static final String OPT_DSMLV1 = "dsmlv1";
    protected static final String OPT_DSMLV2 = "dsmlv2";
    protected List<String> opts = new ArrayList<String>();
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Options options = new Options();
    protected boolean outputDsmlv1;
    protected boolean outputDsmlv2;

    public AbstractCli() {
        this.opts.add(OPT_HELP);
        this.opts.add(OPT_TRACE);
        this.opts.add(OPT_USE_PROPERTIES);
        this.opts.add(OPT_DSMLV1);
        this.opts.add(OPT_DSMLV2);
    }

    public final void performAction(String[] args) {
        this.initOptions();
        try {
            if (args.length > 0) {
                GnuParser parser = new GnuParser();
                CommandLine line = parser.parse(this.options, args);
                this.dispatch(line);
            } else {
                this.printExamples();
            }
        }
        catch (ParseException pex) {
            System.err.println("Failed parsing command arguments: " + pex.getMessage());
        }
        catch (IllegalArgumentException iaex) {
            String msg = "Operation failed: " + iaex.getMessage();
            if (iaex.getCause() != null) {
                msg = msg + " Underlying reason: " + iaex.getCause().getMessage();
            }
            System.err.println(msg);
        }
        catch (Exception ex) {
            System.err.println("Operation failed:");
            ex.printStackTrace(System.err);
        }
    }

    protected abstract void initOptions();

    protected void initOptions(LdapConfigPropertyInvoker invoker) {
        Map<String, String> args = this.getArgs();
        for (String s : invoker.getProperties()) {
            String arg = s.substring(s.lastIndexOf(".") + 1, s.length());
            if (!args.containsKey(arg)) continue;
            this.options.addOption(new Option(arg, true, args.get(arg)));
        }
        this.options.addOption(new Option(OPT_HELP, false, "display all options"));
        this.options.addOption(new Option(OPT_TRACE, false, "print ASN.1 BER packets to System.out"));
        this.options.addOption(new Option(OPT_USE_PROPERTIES, false, "load options from the default properties file"));
        this.options.addOption(new Option(OPT_DSMLV1, false, "output results in DSML v1"));
        this.options.addOption(new Option(OPT_DSMLV2, false, "output results in DSML v2"));
    }

    protected abstract String getCommandName();

    protected abstract void dispatch(CommandLine var1) throws Exception;

    protected void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getCommandName(), this.options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printExamples() {
        String fullName = this.getClass().getName();
        String name = fullName.substring(fullName.lastIndexOf(46) + 1);
        InputStream in = this.getClass().getResourceAsStream(name + ".examples");
        if (in != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                System.out.println();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading examples from resource stream.");
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    System.err.println("Error closing example resource stream.");
                }
                System.out.println();
            }
        } else {
            System.out.println("No usage examples available for " + this.getCommandName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        String fullName = this.getClass().getName();
        String name = fullName.substring(fullName.lastIndexOf(46) + 1);
        InputStream in = this.getClass().getResourceAsStream(name + ".args");
        if (in != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                System.out.println();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] s = line.split(":");
                    if (s.length <= 1) continue;
                    args.put(s[0], s[1]);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading arguments from resource stream.");
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    System.err.println("Error closing arguments resource stream.");
                }
                System.out.println();
            }
        } else {
            System.out.println("No arguments available for " + this.getCommandName());
        }
        return args;
    }

    protected void initLdapProperties(PropertyConfig config, CommandLine line) throws Exception {
        LdapProperties ldapProperties = new LdapProperties(config);
        for (Option o : line.getOptions()) {
            if (o.getOpt().equals(OPT_USE_PROPERTIES)) {
                ldapProperties.useDefaultPropertiesFile();
                continue;
            }
            if (this.opts.contains(o.getOpt())) continue;
            ldapProperties.setProperty(o.getOpt(), o.getValue());
        }
        ldapProperties.configure();
    }
}

