/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.LdapConstants;
import edu.vt.middleware.ldap.handler.ConnectionHandler;
import edu.vt.middleware.ldap.handler.DefaultConnectionHandler;
import edu.vt.middleware.ldap.handler.FqdnSearchResultHandler;
import edu.vt.middleware.ldap.handler.SearchResultHandler;
import edu.vt.middleware.ldap.handler.TlsConnectionHandler;
import edu.vt.middleware.ldap.props.AbstractPropertyConfig;
import edu.vt.middleware.ldap.props.LdapConfigPropertyInvoker;
import edu.vt.middleware.ldap.props.LdapProperties;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.CommunicationException;
import javax.naming.LimitExceededException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.SearchControls;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConfig
extends AbstractPropertyConfig {
    public static final String PROPERTIES_DOMAIN = "edu.vt.middleware.ldap.";
    private static final LdapConfigPropertyInvoker PROPERTIES = new LdapConfigPropertyInvoker(LdapConfig.class, "edu.vt.middleware.ldap.");
    private String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private ConnectionHandler connectionHandler = new DefaultConnectionHandler(this);
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private String ldapUrl;
    private String host;
    private String port = "389";
    private Integer timeout;
    private String bindDn;
    private Object bindCredential;
    private String baseDn = "";
    private SearchScope searchScope = SearchScope.SUBTREE;
    private String authtype = "simple";
    private boolean authoritative = false;
    private Integer batchSize;
    private Integer timeLimit;
    private Long countLimit;
    private Integer pagedResultsSize;
    private Integer operationRetry;
    private Class<?>[] operationRetryExceptions = new Class[]{CommunicationException.class, ServiceUnavailableException.class};
    private Long operationRetryWait;
    private Integer operationRetryBackoff;
    private boolean derefLinkFlag;
    private boolean returningObjFlag;
    private String dnsUrl;
    private String language;
    private String referral;
    private String derefAliases;
    private String binaryAttributes;
    private SearchResultHandler[] searchResultHandlers = new SearchResultHandler[]{new FqdnSearchResultHandler()};
    private Class<?>[] handlerIgnoreExceptions = new Class[]{LimitExceededException.class};
    private String saslAuthorizationId;
    private String saslRealm;
    private boolean typesOnly = false;
    private Map<String, Object> additionalEnvironmentProperties = new HashMap<String, Object>();
    private boolean logCredentials = false;
    private boolean ssl = false;
    private PrintStream tracePackets;

    public LdapConfig() {
    }

    public LdapConfig(String ldapUrl) {
        this();
        this.setLdapUrl(ldapUrl);
    }

    public LdapConfig(String ldapUrl, String baseDn) {
        this();
        this.setLdapUrl(ldapUrl);
        this.setBaseDn(baseDn);
    }

    public Hashtable<String, ?> getEnvironment() {
        Hashtable<String, Object> environment = new Hashtable<String, Object>();
        environment.put("java.naming.factory.initial", this.contextFactory);
        if (this.authoritative) {
            environment.put("java.naming.authoritative", Boolean.valueOf(this.authoritative).toString());
        }
        if (this.batchSize != null) {
            environment.put("java.naming.batchsize", this.batchSize.toString());
        }
        if (this.dnsUrl != null) {
            environment.put("java.naming.dns.url", this.dnsUrl);
        }
        if (this.language != null) {
            environment.put("java.naming.language", this.language);
        }
        if (this.referral != null) {
            environment.put("java.naming.referral", this.referral);
        }
        if (this.derefAliases != null) {
            environment.put("java.naming.ldap.derefAliases", this.derefAliases);
        }
        if (this.binaryAttributes != null) {
            environment.put("java.naming.ldap.attributes.binary", this.binaryAttributes);
        }
        if (this.saslAuthorizationId != null) {
            environment.put("java.naming.security.sasl.authorizationId", this.saslAuthorizationId);
        }
        if (this.saslRealm != null) {
            environment.put("java.naming.security.sasl.realm", this.saslRealm);
        }
        if (this.typesOnly) {
            environment.put("java.naming.ldap.typesOnly", Boolean.valueOf(this.typesOnly).toString());
        }
        if (this.ssl) {
            environment.put("java.naming.security.protocol", "ssl");
            if (this.sslSocketFactory != null) {
                environment.put("java.naming.ldap.factory.socket", this.sslSocketFactory.getClass().getName());
            }
        }
        if (this.tracePackets != null) {
            environment.put("com.sun.jndi.ldap.trace.ber", this.tracePackets);
        }
        if (this.ldapUrl != null) {
            environment.put("java.naming.provider.url", this.ldapUrl);
        }
        if (this.timeout != null) {
            environment.put("com.sun.jndi.ldap.connect.timeout", this.timeout.toString());
        }
        if (!this.additionalEnvironmentProperties.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.additionalEnvironmentProperties.entrySet()) {
                environment.put(entry.getKey(), entry.getValue());
            }
        }
        return environment;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public boolean useSslSocketFactory() {
        return this.sslSocketFactory != null;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public boolean useHostnameVerifier() {
        return this.hostnameVerifier != null;
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    @Deprecated
    public String getHost() {
        return this.host;
    }

    @Deprecated
    public String getPort() {
        return this.port;
    }

    public int getTimeout() {
        int time = -1;
        if (this.timeout != null) {
            time = this.timeout;
        }
        return time;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    @Deprecated
    public String getServiceUser() {
        return this.getBindDn();
    }

    public Object getBindCredential() {
        return this.bindCredential;
    }

    @Deprecated
    public Object getServiceCredential() {
        return this.getBindCredential();
    }

    public String getBase() {
        return this.getBaseDn();
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public SearchScope getSearchScope() {
        return this.searchScope;
    }

    public boolean isObjectSearchScope() {
        return this.searchScope == SearchScope.OBJECT;
    }

    public boolean isOneLevelSearchScope() {
        return this.searchScope == SearchScope.ONELEVEL;
    }

    public boolean isSubTreeSearchScope() {
        return this.searchScope == SearchScope.SUBTREE;
    }

    public String getAuthtype() {
        return this.authtype;
    }

    public boolean isAnonymousAuth() {
        return this.authtype.equalsIgnoreCase("none");
    }

    public boolean isSimpleAuth() {
        return this.authtype.equalsIgnoreCase("simple");
    }

    public boolean isStrongAuth() {
        return this.authtype.equalsIgnoreCase("strong");
    }

    public boolean isSaslAuth() {
        boolean authtypeSasl = false;
        for (String sasl : LdapConstants.SASL_MECHANISMS) {
            if (!this.authtype.equalsIgnoreCase(sasl)) continue;
            authtypeSasl = true;
            break;
        }
        return authtypeSasl;
    }

    public boolean isExternalAuth() {
        return this.authtype.equalsIgnoreCase("EXTERNAL");
    }

    public boolean isDigestMD5Auth() {
        return this.authtype.equalsIgnoreCase("DIGEST-MD5");
    }

    public boolean isCramMD5Auth() {
        return this.authtype.equalsIgnoreCase("CRAM-MD5");
    }

    public boolean isGSSAPIAuth() {
        return this.authtype.equalsIgnoreCase("GSSAPI");
    }

    public boolean getAuthoritative() {
        return this.isAuthoritative();
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public int getTimeLimit() {
        int limit = 0;
        if (this.timeLimit != null) {
            limit = this.timeLimit;
        }
        return limit;
    }

    public long getCountLimit() {
        long limit = 0L;
        if (this.countLimit != null) {
            limit = this.countLimit;
        }
        return limit;
    }

    public int getPagedResultsSize() {
        int size = 0;
        if (this.pagedResultsSize != null) {
            size = this.pagedResultsSize;
        }
        return size;
    }

    public int getOperationRetry() {
        int retry = 1;
        if (this.operationRetry != null) {
            retry = this.operationRetry;
        }
        return retry;
    }

    public Class<?>[] getOperationRetryExceptions() {
        return this.operationRetryExceptions;
    }

    public long getOperationRetryWait() {
        long wait = 0L;
        if (this.operationRetryWait != null) {
            wait = this.operationRetryWait.intValue();
        }
        return wait;
    }

    public int getOperationRetryBackoff() {
        int backoff = 0;
        if (this.operationRetryBackoff != null) {
            backoff = this.operationRetryBackoff;
        }
        return backoff;
    }

    public boolean getDerefLinkFlag() {
        return this.derefLinkFlag;
    }

    public boolean getReturningObjFlag() {
        return this.returningObjFlag;
    }

    public int getBatchSize() {
        int size = -1;
        if (this.batchSize != null) {
            size = this.batchSize;
        }
        return size;
    }

    public String getDnsUrl() {
        return this.dnsUrl;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getReferral() {
        return this.referral;
    }

    public String getDerefAliases() {
        return this.derefAliases;
    }

    public String getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public SearchResultHandler[] getSearchResultHandlers() {
        return this.searchResultHandlers;
    }

    public Class<?>[] getHandlerIgnoreExceptions() {
        return this.handlerIgnoreExceptions;
    }

    public String getSaslAuthorizationId() {
        return this.saslAuthorizationId;
    }

    public String getSaslRealm() {
        return this.saslRealm;
    }

    public boolean getTypesOnly() {
        return this.isTypesOnly();
    }

    public boolean isTypesOnly() {
        return this.typesOnly;
    }

    public Map<String, Object> getEnvironmentProperties() {
        return Collections.unmodifiableMap(this.additionalEnvironmentProperties);
    }

    public boolean getLogCredentials() {
        return this.logCredentials;
    }

    public boolean getSsl() {
        return this.isSslEnabled();
    }

    public boolean isSslEnabled() {
        return this.ssl;
    }

    public boolean getTls() {
        return this.isTlsEnabled();
    }

    public boolean isTlsEnabled() {
        return this.connectionHandler != null && this.connectionHandler.getClass().isAssignableFrom(TlsConnectionHandler.class);
    }

    public void setContextFactory(String contextFactory) {
        this.checkImmutable();
        this.checkStringInput(contextFactory, false);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting contextFactory: " + contextFactory));
        }
        this.contextFactory = contextFactory;
    }

    public void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting connectionHandler: " + connectionHandler));
        }
        this.connectionHandler = connectionHandler;
        if (this.connectionHandler != null) {
            this.connectionHandler.setLdapConfig(this);
        }
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting sslSocketFactory: " + sslSocketFactory));
        }
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting hostnameVerifier: " + hostnameVerifier));
        }
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setLdapUrl(String ldapUrl) {
        this.checkImmutable();
        this.checkStringInput(ldapUrl, true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting ldapUrl: " + ldapUrl));
        }
        this.ldapUrl = ldapUrl;
    }

    @Deprecated
    public void setHost(String host) {
        this.checkImmutable();
        if (host != null) {
            int prefixLength = "://".length();
            int separatorLength = ":".length();
            String h = host;
            if (h.indexOf("://") != -1 && h.indexOf("://") + prefixLength < h.length()) {
                String scheme = h.substring(0, h.indexOf("://"));
                if (scheme.equalsIgnoreCase("ldaps")) {
                    this.setSsl(true);
                    this.setPort("636");
                }
                h = h.substring(h.indexOf("://") + prefixLength, h.length());
            }
            if (h.indexOf(":") != -1 && h.indexOf(":") + separatorLength < h.length()) {
                String p;
                this.port = p = h.substring(h.indexOf(":") + separatorLength, h.length());
                h = h.substring(0, h.indexOf(":"));
            }
            this.host = h;
            this.setLdapUrl("ldap://" + this.host + ":" + this.port);
        }
    }

    @Deprecated
    public void setPort(String port) {
        this.checkImmutable();
        this.port = port;
        if (this.host != null) {
            this.setLdapUrl("ldap://" + this.host + ":" + this.port);
        }
    }

    public void setTimeout(int timeout) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting timeout: " + timeout));
        }
        this.timeout = new Integer(timeout);
    }

    public void setBindDn(String dn) {
        this.checkImmutable();
        this.checkStringInput(dn, true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting bindDn: " + dn));
        }
        this.bindDn = dn;
    }

    @Deprecated
    public void setServiceUser(String user) {
        this.setBindDn(user);
    }

    public void setBindCredential(Object credential) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            if (this.getLogCredentials()) {
                this.logger.trace((Object)("setting bindCredential: " + credential));
            } else {
                this.logger.trace((Object)"setting bindCredential: <suppressed>");
            }
        }
        this.bindCredential = credential;
    }

    @Deprecated
    public void setServiceCredential(Object credential) {
        this.setBindCredential(credential);
    }

    @Deprecated
    public void setService(String user, Object credential) {
        this.setBindDn(user);
        this.setBindCredential(credential);
    }

    public void setBase(String base) {
        this.setBaseDn(base);
    }

    public void setBaseDn(String baseDn) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting baseDn: " + baseDn));
        }
        this.baseDn = baseDn;
    }

    public void setSearchScope(SearchScope searchScope) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting searchScope: " + (Object)((Object)searchScope)));
        }
        this.searchScope = searchScope;
    }

    public void setAuthtype(String authtype) {
        this.checkImmutable();
        this.checkStringInput(authtype, false);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting authtype: " + authtype));
        }
        this.authtype = authtype;
    }

    public void setAuthoritative(boolean authoritative) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting authoritative: " + authoritative));
        }
        this.authoritative = authoritative;
    }

    public void setTimeLimit(int timeLimit) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting timeLimit: " + timeLimit));
        }
        this.timeLimit = new Integer(timeLimit);
    }

    public void setCountLimit(long countLimit) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting countLimit: " + countLimit));
        }
        this.countLimit = new Long(countLimit);
    }

    public void setPagedResultsSize(int pageSize) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting pagedResultsSize: " + pageSize));
        }
        this.pagedResultsSize = new Integer(pageSize);
    }

    public void setOperationRetry(int operationRetry) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting operationRetry: " + operationRetry));
        }
        this.operationRetry = new Integer(operationRetry);
    }

    public void setOperationRetryExceptions(Class<?>[] exceptions) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting operationRetryExceptions: " + Arrays.toString(exceptions)));
        }
        this.operationRetryExceptions = exceptions;
    }

    public void setOperationRetryWait(long wait) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting operationRetryWait: " + wait));
        }
        this.operationRetryWait = new Long(wait);
    }

    public void setOperationRetryBackoff(int backoff) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting operationRetryBackoff: " + backoff));
        }
        this.operationRetryBackoff = new Integer(backoff);
    }

    public void setDerefLinkFlag(boolean derefLinkFlag) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting derefLinkFlag: " + derefLinkFlag));
        }
        this.derefLinkFlag = derefLinkFlag;
    }

    public void setReturningObjFlag(boolean returningObjFlag) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting returningObjFlag: " + returningObjFlag));
        }
        this.returningObjFlag = returningObjFlag;
    }

    public void setBatchSize(int batchSize) {
        this.checkImmutable();
        if (batchSize == -1) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("setting batchSize: " + null));
            }
            this.batchSize = null;
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("setting batchSize: " + batchSize));
            }
            this.batchSize = new Integer(batchSize);
        }
    }

    public void setDnsUrl(String dnsUrl) {
        this.checkImmutable();
        this.checkStringInput(dnsUrl, true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting dnsUrl: " + dnsUrl));
        }
        this.dnsUrl = dnsUrl;
    }

    public void setLanguage(String language) {
        this.checkImmutable();
        this.checkStringInput(language, true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting language: " + language));
        }
        this.language = language;
    }

    public void setReferral(String referral) {
        this.checkImmutable();
        this.checkStringInput(referral, true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting referral: " + referral));
        }
        this.referral = referral;
    }

    public void setDerefAliases(String derefAliases) {
        this.checkImmutable();
        this.checkStringInput(derefAliases, true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting derefAliases: " + derefAliases));
        }
        this.derefAliases = derefAliases;
    }

    public void setBinaryAttributes(String binaryAttributes) {
        this.checkImmutable();
        this.checkStringInput(binaryAttributes, true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting binaryAttributes: " + binaryAttributes));
        }
        this.binaryAttributes = binaryAttributes;
    }

    public void setSearchResultHandlers(SearchResultHandler[] handlers) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting searchResultsHandlers: " + Arrays.toString(handlers)));
        }
        this.searchResultHandlers = handlers;
    }

    public void setHandlerIgnoreExceptions(Class<?>[] exceptions) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting handlerIgnoreExceptions: " + Arrays.toString(exceptions)));
        }
        this.handlerIgnoreExceptions = exceptions;
    }

    public void setSaslAuthorizationId(String saslAuthorizationId) {
        this.checkImmutable();
        this.checkStringInput(saslAuthorizationId, true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting saslAuthorizationId: " + saslAuthorizationId));
        }
        this.saslAuthorizationId = saslAuthorizationId;
    }

    public void setSaslRealm(String saslRealm) {
        this.checkImmutable();
        this.checkStringInput(saslRealm, true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting saslRealm: " + saslRealm));
        }
        this.saslRealm = saslRealm;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting typesOnly: " + typesOnly));
        }
        this.typesOnly = typesOnly;
    }

    @Override
    public String getPropertiesDomain() {
        return PROPERTIES_DOMAIN;
    }

    @Override
    public void setEnvironmentProperties(String name, String value) {
        this.checkImmutable();
        if (name != null && value != null) {
            if (PROPERTIES.hasProperty(name)) {
                PROPERTIES.setProperty(this, name, value);
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("setting property " + name + ": " + value));
                }
                this.additionalEnvironmentProperties.put(name, value);
            }
        }
    }

    @Override
    public boolean hasEnvironmentProperty(String name) {
        return PROPERTIES.hasProperty(name);
    }

    public static LdapConfig createFromProperties(InputStream is) {
        LdapConfig ldapConfig = new LdapConfig();
        LdapProperties properties = null;
        if (is != null) {
            properties = new LdapProperties(ldapConfig, is);
        } else {
            properties = new LdapProperties(ldapConfig);
            properties.useDefaultPropertiesFile();
        }
        properties.configure();
        return ldapConfig;
    }

    public void setLogCredentials(boolean log) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting logCredentials: " + log));
        }
        this.logCredentials = log;
    }

    public void setSsl(boolean ssl) {
        this.checkImmutable();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("setting ssl: " + ssl));
        }
        this.ssl = ssl;
    }

    public void setTls(boolean tls) {
        if (tls) {
            this.setConnectionHandler(new TlsConnectionHandler());
        } else {
            this.setConnectionHandler(new DefaultConnectionHandler());
        }
    }

    public SearchControls getSearchControls(String[] retAttrs) {
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(retAttrs);
        ctls.setSearchScope(this.getSearchScope().ordinal());
        ctls.setTimeLimit(this.getTimeLimit());
        ctls.setCountLimit(this.getCountLimit());
        ctls.setDerefLinkFlag(this.getDerefLinkFlag());
        ctls.setReturningObjFlag(this.getReturningObjFlag());
        return ctls;
    }

    public static SearchControls getCompareSearchControls() {
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(new String[0]);
        ctls.setSearchScope(SearchScope.OBJECT.ordinal());
        return ctls;
    }

    public void setTracePackets(PrintStream stream) {
        this.checkImmutable();
        this.tracePackets = stream;
    }

    public String toString() {
        return String.format("%s@%d::env=%s", this.getClass().getName(), this.hashCode(), this.getEnvironment());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchScope {
        OBJECT(0),
        ONELEVEL(1),
        SUBTREE(2);

        private int scope;

        private SearchScope(int i) {
            this.scope = i;
        }

        public int scope() {
            return this.scope;
        }

        public static SearchScope parseSearchScope(int i) {
            SearchScope ss = null;
            if (OBJECT.scope() == i) {
                ss = OBJECT;
            } else if (ONELEVEL.scope() == i) {
                ss = ONELEVEL;
            } else if (SUBTREE.scope() == i) {
                ss = SUBTREE;
            }
            return ss;
        }
    }
}

