/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.bean;

import edu.vt.middleware.ldap.bean.AbstractLdapBean;
import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import edu.vt.middleware.ldap.bean.LdapEntry;
import edu.vt.middleware.ldap.bean.LdapResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLdapResult<T extends Map<String, LdapEntry>>
extends AbstractLdapBean
implements LdapResult {
    protected static final int HASH_CODE_SEED = 44;
    protected T entries;

    public AbstractLdapResult(LdapBeanFactory lbf) {
        super(lbf);
    }

    @Override
    public Collection<LdapEntry> getEntries() {
        return this.entries.values();
    }

    @Override
    public LdapEntry getEntry(String dn) {
        return (LdapEntry)this.entries.get(dn);
    }

    @Override
    public void addEntry(LdapEntry e) {
        this.entries.put((String)e.getDn(), (LdapEntry)e);
    }

    @Override
    public void addEntry(SearchResult sr) throws NamingException {
        LdapEntry le = this.beanFactory.newLdapEntry();
        le.setEntry(sr);
        this.addEntry(le);
    }

    @Override
    public void addEntries(Collection<LdapEntry> c) {
        for (LdapEntry e : c) {
            this.entries.put((String)e.getDn(), (LdapEntry)e);
        }
    }

    @Override
    public void addEntries(NamingEnumeration<SearchResult> ne) throws NamingException {
        while (ne.hasMore()) {
            LdapEntry le = this.beanFactory.newLdapEntry();
            le.setEntry(ne.next());
            this.addEntry(le);
        }
    }

    @Override
    public void addEntries(Iterator<SearchResult> i) throws NamingException {
        while (i.hasNext()) {
            LdapEntry le = this.beanFactory.newLdapEntry();
            le.setEntry(i.next());
            this.addEntry(le);
        }
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public int hashCode() {
        int hc = 44;
        for (LdapEntry e : this.entries.values()) {
            if (e == null) continue;
            hc += e.hashCode();
        }
        return hc;
    }

    public String toString() {
        return String.format("%s", this.entries.values());
    }

    @Override
    public List<SearchResult> toSearchResults() {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>(this.entries.size());
        for (LdapEntry e : this.entries.values()) {
            results.add(e.toSearchResult());
        }
        return results;
    }
}

