/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.handler;

import edu.vt.middleware.ldap.handler.CopySearchResultHandler;
import edu.vt.middleware.ldap.handler.SearchCriteria;
import java.net.URI;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.directory.SearchResult;

public class FqdnSearchResultHandler
extends CopySearchResultHandler {
    private boolean removeUrls = true;

    public boolean getRemoveUrls() {
        return this.removeUrls;
    }

    public void setRemoveUrls(boolean b) {
        this.removeUrls = b;
    }

    protected String processDn(SearchCriteria sc, SearchResult sr) {
        String newDn = null;
        String resultName = sr.getName();
        if (resultName != null) {
            StringBuffer fqName = null;
            if (sr.isRelative()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("processing relative dn: " + resultName));
                }
                fqName = sc.getDn() != null ? (!"".equals(resultName) ? new StringBuffer(this.readCompositeName(resultName)).append(",").append(sc.getDn()) : new StringBuffer(sc.getDn())) : new StringBuffer(this.readCompositeName(resultName));
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("processing non-relative dn: " + resultName));
                }
                fqName = this.removeUrls ? new StringBuffer(this.readCompositeName(URI.create(resultName).getPath().substring(1))) : new StringBuffer(this.readCompositeName(resultName));
            }
            newDn = fqName.toString();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("processed dn: " + newDn));
        }
        return newDn;
    }

    private String readCompositeName(String s) {
        StringBuffer name;
        block3: {
            name = new StringBuffer();
            try {
                CompositeName cName = new CompositeName(s);
                for (int i = 0; i < cName.size(); ++i) {
                    name.append(cName.get(i));
                    if (i + 1 >= cName.size()) continue;
                    name.append("/");
                }
            }
            catch (InvalidNameException e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error((Object)("Error formatting name: " + s), (Throwable)e);
            }
        }
        return name.toString();
    }
}

