/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.pool;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.pool.AbstractLdapPool;
import edu.vt.middleware.ldap.pool.BlockingTimeoutException;
import edu.vt.middleware.ldap.pool.DefaultLdapFactory;
import edu.vt.middleware.ldap.pool.LdapFactory;
import edu.vt.middleware.ldap.pool.LdapPoolConfig;
import edu.vt.middleware.ldap.pool.LdapPoolException;
import edu.vt.middleware.ldap.pool.LdapPoolExhaustedException;
import edu.vt.middleware.ldap.pool.PoolInterruptedException;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingLdapPool
extends AbstractLdapPool<Ldap> {
    private long blockWaitTime;

    public BlockingLdapPool() {
        super(new LdapPoolConfig(), new DefaultLdapFactory());
    }

    public BlockingLdapPool(LdapFactory<Ldap> lf) {
        super(new LdapPoolConfig(), lf);
    }

    public BlockingLdapPool(LdapPoolConfig lpc, LdapFactory<Ldap> lf) {
        super(lpc, lf);
    }

    public long getBlockWaitTime() {
        return this.blockWaitTime;
    }

    public void setBlockWaitTime(long time) {
        if (time >= 0L) {
            this.blockWaitTime = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ldap checkOut() throws LdapPoolException {
        boolean create;
        Ldap l;
        block29: {
            l = null;
            create = false;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("waiting on pool lock for check out " + this.poolLock.getQueueLength()));
            }
            this.poolLock.lock();
            try {
                if (this.available.size() > 0) {
                    try {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)"retrieve available ldap object");
                        }
                        l = this.retrieveAvailable();
                        break block29;
                    }
                    catch (NoSuchElementException e) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error((Object)"could not remove ldap object from list", (Throwable)e);
                        }
                        throw new IllegalStateException("Pool is empty", e);
                    }
                }
                if (this.active.size() < this.poolConfig.getMaxPoolSize()) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)"pool can grow, attempt to create ldap object");
                    }
                    create = true;
                } else {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)"pool is full, block until ldap object is available");
                    }
                    l = this.blockAvailable();
                }
            }
            finally {
                this.poolLock.unlock();
            }
        }
        if (create) {
            this.checkOutLock.lock();
            try {
                boolean b = true;
                this.poolLock.lock();
                try {
                    if (this.available.size() + this.active.size() == this.poolConfig.getMaxPoolSize()) {
                        b = false;
                    }
                }
                finally {
                    this.poolLock.unlock();
                }
                if (b) {
                    l = (Ldap)this.createActive();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("created new active ldap object: " + l));
                    }
                }
            }
            finally {
                this.checkOutLock.unlock();
            }
            if (l == null) {
                if (this.available.size() == 0 && this.active.size() == 0) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)"Could not service check out request");
                    }
                    throw new LdapPoolExhaustedException("Pool is empty and object creation failed");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"create failed, block until ldap object is available");
                }
                l = this.blockAvailable();
            }
        }
        if (l == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"Could not service check out request");
            }
            throw new LdapPoolExhaustedException("Pool is empty and object creation failed");
        }
        this.activateAndValidate(l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Ldap retrieveAvailable() {
        Ldap l = null;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("waiting on pool lock for retrieve available " + this.poolLock.getQueueLength()));
        }
        this.poolLock.lock();
        try {
            AbstractLdapPool.PooledLdap pl = (AbstractLdapPool.PooledLdap)this.available.remove();
            this.active.add(new AbstractLdapPool.PooledLdap(pl.getLdap()));
            l = (Ldap)pl.getLdap();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("retrieved available ldap object: " + l));
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return l;
    }

    protected Ldap blockAvailable() throws LdapPoolException {
        Ldap l = null;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("waiting on pool lock for block available " + this.poolLock.getQueueLength()));
        }
        this.poolLock.lock();
        try {
            while (l == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"available pool is empty, waiting...");
                }
                if (this.blockWaitTime > 0L) {
                    if (!this.poolNotEmpty.await(this.blockWaitTime, TimeUnit.MILLISECONDS)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"block time exceeded, throwing exception");
                        }
                        throw new BlockingTimeoutException("Block time exceeded");
                    }
                } else {
                    this.poolNotEmpty.await();
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"notified to continue...");
                }
                try {
                    l = this.retrieveAvailable();
                }
                catch (NoSuchElementException e) {
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace((Object)"notified to continue but pool was empty");
                }
            }
        }
        catch (InterruptedException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"waiting for available object interrupted", (Throwable)e);
            }
            throw new PoolInterruptedException("Interrupted while waiting for an available object", e);
        }
        finally {
            this.poolLock.unlock();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIn(Ldap l) {
        boolean valid = this.validateAndPassivate(l);
        AbstractLdapPool.PooledLdap<Ldap> pl = new AbstractLdapPool.PooledLdap<Ldap>(l);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("waiting on pool lock for check in " + this.poolLock.getQueueLength()));
        }
        this.poolLock.lock();
        try {
            if (this.active.remove(pl)) {
                if (valid) {
                    this.available.add(pl);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("returned active ldap object: " + l));
                    }
                    this.poolNotEmpty.signal();
                }
            } else if (this.available.contains(pl)) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("returned available ldap object: " + l));
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("attempt to return unknown ldap object: " + l));
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }
}

