/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.pool;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.pool.AbstractLdapPool;
import edu.vt.middleware.ldap.pool.DefaultLdapFactory;
import edu.vt.middleware.ldap.pool.LdapFactory;
import edu.vt.middleware.ldap.pool.LdapPoolConfig;
import edu.vt.middleware.ldap.pool.LdapPoolException;
import edu.vt.middleware.ldap.pool.LdapPoolExhaustedException;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedLdapPool
extends AbstractLdapPool<Ldap> {
    public SharedLdapPool() {
        super(new LdapPoolConfig(), new DefaultLdapFactory());
    }

    public SharedLdapPool(LdapFactory<Ldap> lf) {
        super(new LdapPoolConfig(), lf);
    }

    public SharedLdapPool(LdapPoolConfig lpc, LdapFactory<Ldap> lf) {
        super(lpc, lf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ldap checkOut() throws LdapPoolException {
        Ldap l = null;
        boolean create = false;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("waiting on pool lock for check out " + this.poolLock.getQueueLength()));
        }
        this.poolLock.lock();
        try {
            if (this.active.size() < this.available.size()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"retrieve available ldap object");
                }
                l = this.retrieveAvailable();
            } else if (this.active.size() < this.poolConfig.getMaxPoolSize()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"pool can grow, attempt to create ldap object");
                }
                create = true;
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"pool is full, attempt to retrieve available ldap object");
                }
                l = this.retrieveAvailable();
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (create) {
            this.checkOutLock.lock();
            try {
                boolean b = true;
                this.poolLock.lock();
                try {
                    if (this.available.size() == this.poolConfig.getMaxPoolSize()) {
                        b = false;
                    }
                }
                finally {
                    this.poolLock.unlock();
                }
                if (b) {
                    l = (Ldap)this.createAvailableAndActive();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("created new available and active ldap object: " + l));
                    }
                }
            }
            finally {
                this.checkOutLock.unlock();
            }
            if (l == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"create failed, retrieve available ldap object");
                }
                l = this.retrieveAvailable();
            }
        }
        if (l == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"Could not service check out request");
            }
            throw new LdapPoolExhaustedException("Pool is empty and object creation failed");
        }
        this.activateAndValidate(l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Ldap retrieveAvailable() {
        Ldap l = null;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("waiting on pool lock for retrieve available " + this.poolLock.getQueueLength()));
        }
        this.poolLock.lock();
        try {
            try {
                AbstractLdapPool.PooledLdap pl = (AbstractLdapPool.PooledLdap)this.available.remove();
                this.active.add(new AbstractLdapPool.PooledLdap(pl.getLdap()));
                this.available.add(new AbstractLdapPool.PooledLdap(pl.getLdap()));
                l = (Ldap)pl.getLdap();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("retrieved available ldap object: " + l));
                }
            }
            catch (NoSuchElementException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)"could not remove ldap object from list", (Throwable)e);
                }
                throw new IllegalStateException("Pool is empty", e);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIn(Ldap l) {
        boolean valid = this.validateAndPassivate(l);
        AbstractLdapPool.PooledLdap<Ldap> pl = new AbstractLdapPool.PooledLdap<Ldap>(l);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("waiting on pool lock for check in " + this.poolLock.getQueueLength()));
        }
        this.poolLock.lock();
        try {
            if (this.active.remove(pl)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("returned active ldap object: " + l));
                }
            } else if (this.available.contains(pl)) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("returned available ldap object: " + l));
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("attempt to return unknown ldap object: " + l));
            }
            if (!valid) {
                this.available.remove(pl);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }
}

