/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.props;

import edu.vt.middleware.ldap.props.PropertyConfig;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyConfig
implements PropertyConfig {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean immutable;

    public void makeImmutable() {
        this.immutable = true;
    }

    public void checkImmutable() {
        if (this.immutable) {
            throw new IllegalStateException("Cannot modify immutable object");
        }
    }

    @Override
    public abstract String getPropertiesDomain();

    @Override
    public abstract void setEnvironmentProperties(String var1, String var2);

    @Override
    public void setEnvironmentProperties(Properties properties) {
        if (properties != null) {
            HashMap<String, String> props = new HashMap<String, String>();
            Enumeration<Object> en = properties.keys();
            if (en != null) {
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    String value = (String)properties.get(name);
                    if (this.hasEnvironmentProperty(name)) {
                        props.put(name, value);
                        continue;
                    }
                    this.setEnvironmentProperties(name, value);
                }
                for (Map.Entry e : props.entrySet()) {
                    this.setEnvironmentProperties((String)e.getKey(), (String)e.getValue());
                }
            }
        }
    }

    @Override
    public void setEnvironmentProperties(Hashtable<String, String> properties) {
        if (properties != null) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (this.hasEnvironmentProperty(entry.getKey())) {
                    props.put(entry.getKey(), entry.getValue());
                    continue;
                }
                this.setEnvironmentProperties(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : props.entrySet()) {
                this.setEnvironmentProperties(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public abstract boolean hasEnvironmentProperty(String var1);

    protected void checkStringInput(String s, boolean allowNull) {
        if (allowNull) {
            if (s != null && "".equals(s)) {
                throw new IllegalArgumentException("Input cannot be empty");
            }
        } else if (s == null || "".equals(s)) {
            throw new IllegalArgumentException("Input cannot be null or empty");
        }
    }
}

