/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.props;

import edu.vt.middleware.ldap.props.PropertyConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LdapProperties {
    public static final String PROPERTIES_FILE = "/ldap.properties";
    private final Log logger = LogFactory.getLog(LdapProperties.class);
    private PropertyConfig propertyConfig;
    private Properties config;

    public LdapProperties(PropertyConfig pc) {
        this.propertyConfig = pc;
        this.config = new Properties();
    }

    public LdapProperties(PropertyConfig pc, InputStream is) {
        this.propertyConfig = pc;
        this.useProperties(is);
    }

    public void useDefaultPropertiesFile() {
        this.useProperties(LdapProperties.class.getResourceAsStream(PROPERTIES_FILE));
    }

    public void useProperties(InputStream is) {
        if (this.config == null) {
            this.config = this.loadProperties(is);
        } else {
            this.config.putAll((Map<?, ?>)this.loadProperties(is));
        }
    }

    private Properties loadProperties(InputStream is) {
        Properties properties = new Properties();
        if (is != null) {
            try {
                properties.load(is);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Loaded ldap properties from input stream");
                }
                is.close();
            }
            catch (IOException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)"Error using input stream", (Throwable)e);
                }
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Input stream was null, no properties loaded");
        }
        return properties;
    }

    public Properties getProperties() {
        return this.config;
    }

    public void setProperty(String key, String value) {
        if (this.propertyConfig.hasEnvironmentProperty(this.propertyConfig.getPropertiesDomain() + key)) {
            this.config.setProperty(this.propertyConfig.getPropertiesDomain() + key, value);
        } else {
            this.config.setProperty(key, value);
        }
    }

    public boolean isPropertySet(String key) {
        boolean exists = false;
        exists = this.propertyConfig.hasEnvironmentProperty(this.propertyConfig.getPropertiesDomain() + key) ? this.config.containsKey(this.propertyConfig.getPropertiesDomain() + key) : this.config.containsKey(key);
        return exists;
    }

    public void configure() {
        this.propertyConfig.setEnvironmentProperties(this.config);
    }
}

