/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.SnippetType;
import cucumber.runtime.CucumberException;
import cucumber.runtime.RuntimeOptions;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RuntimeOptionsFactory {
    private final Class clazz;
    private final Class<? extends Annotation>[] annotationClasses;
    private boolean featuresSpecified = false;
    private boolean glueSpecified = false;
    private boolean formatSpecified = false;

    public RuntimeOptionsFactory(Class clazz, Class<? extends Annotation>[] annotationClasses) {
        this.clazz = clazz;
        this.annotationClasses = annotationClasses;
    }

    public RuntimeOptions create() {
        List<String> args = this.buildArgsFromOptions();
        return new RuntimeOptions(args);
    }

    private List<String> buildArgsFromOptions() {
        ArrayList<String> args = new ArrayList<String>();
        Class classWithOptions = this.clazz;
        while (this.hasSuperClass(classWithOptions)) {
            Annotation[] optionsArray;
            for (Annotation options : optionsArray = this.getOptions(classWithOptions)) {
                if (options == null) continue;
                this.addDryRun(options, args);
                this.addMonochrome(options, args);
                this.addTags(options, args);
                this.addFormats(options, args);
                this.addStrict(options, args);
                this.addName(options, args);
                this.addDotCucumber(options, args);
                this.addSnippets(options, args);
                this.addGlue(optionsArray, args);
                this.addFeatures(optionsArray, args);
            }
            classWithOptions = classWithOptions.getSuperclass();
        }
        this.addDefaultFeaturePathIfNoFeaturePathIsSpecified(args, this.clazz);
        this.addDefaultGlueIfNoGlueIsSpecified(args, this.clazz);
        this.addDefaultFormatIfNoFormatIsSpecified(args);
        return args;
    }

    private void addDotCucumber(Annotation options, List<String> args) {
        String dotcucumber = (String)this.invoke(options, "dotcucumber");
        if (!dotcucumber.isEmpty()) {
            args.add("--dotcucumber");
            args.add(dotcucumber);
        }
    }

    private void addName(Annotation options, List<String> args) {
        for (String name : (String[])this.invoke(options, "name")) {
            args.add("--name");
            args.add(name);
        }
    }

    private void addSnippets(Annotation options, List<String> args) {
        args.add("--snippets");
        args.add(((SnippetType)((Object)this.invoke(options, "snippets"))).toString());
    }

    private void addDryRun(Annotation options, List<String> args) {
        if (((Boolean)this.invoke(options, "dryRun")).booleanValue()) {
            args.add("--dry-run");
        }
    }

    private void addMonochrome(Annotation options, List<String> args) {
        if (((Boolean)this.invoke(options, "monochrome")).booleanValue() || this.runningInEnvironmentWithoutAnsiSupport()) {
            args.add("--monochrome");
        }
    }

    private void addTags(Annotation options, List<String> args) {
        for (String tags : (String[])this.invoke(options, "tags")) {
            args.add("--tags");
            args.add(tags);
        }
    }

    private void addFormats(Annotation options, List<String> args) {
        if (((String[])this.invoke(options, "format")).length != 0) {
            for (String format : (String[])this.invoke(options, "format")) {
                args.add("--format");
                args.add(format);
            }
            this.formatSpecified = true;
        }
    }

    private void addDefaultFormatIfNoFormatIsSpecified(List<String> args) {
        if (!this.formatSpecified) {
            args.add("--format");
            args.add("null");
        }
    }

    private void addFeatures(Annotation[] optionsArray, List<String> args) {
        for (Annotation options : optionsArray) {
            if (options == null || ((String[])this.invoke(options, "features")).length == 0) continue;
            Collections.addAll(args, (Object[])this.invoke(options, "features"));
            this.featuresSpecified = true;
        }
    }

    private void addDefaultFeaturePathIfNoFeaturePathIsSpecified(List<String> args, Class clazz) {
        if (!this.featuresSpecified) {
            args.add("classpath:" + RuntimeOptionsFactory.packagePath(clazz));
        }
    }

    private void addGlue(Annotation[] optionsArray, List<String> args) {
        for (Annotation options : optionsArray) {
            if (options == null || ((String[])this.invoke(options, "glue")).length == 0) continue;
            for (String glue : (String[])this.invoke(options, "glue")) {
                args.add("--glue");
                args.add(glue);
            }
            this.glueSpecified = true;
        }
    }

    private void addDefaultGlueIfNoGlueIsSpecified(List<String> args, Class clazz) {
        if (!this.glueSpecified) {
            args.add("--glue");
            args.add("classpath:" + RuntimeOptionsFactory.packagePath(clazz));
        }
    }

    private void addStrict(Annotation options, List<String> args) {
        if (((Boolean)this.invoke(options, "strict")).booleanValue()) {
            args.add("--strict");
        }
    }

    static String packagePath(Class clazz) {
        return RuntimeOptionsFactory.packagePath(RuntimeOptionsFactory.packageName(clazz.getName()));
    }

    static String packagePath(String packageName) {
        return packageName.replace('.', '/');
    }

    static String packageName(String className) {
        return className.substring(0, Math.max(0, className.lastIndexOf(".")));
    }

    private boolean runningInEnvironmentWithoutAnsiSupport() {
        boolean intelliJidea = System.getProperty("idea.launcher.bin.path") != null;
        return intelliJidea;
    }

    private boolean hasSuperClass(Class classWithOptions) {
        return classWithOptions != Object.class;
    }

    private Annotation[] getOptions(Class<?> clazz) {
        Annotation[] annotations = new Annotation[this.annotationClasses.length];
        for (int i = 0; i < annotations.length; ++i) {
            annotations[i] = clazz.getAnnotation(this.annotationClasses[i]);
        }
        return annotations;
    }

    private <T> T invoke(Annotation options, String name) {
        try {
            Method method = options.annotationType().getMethod(name, new Class[0]);
            return (T)method.invoke((Object)options, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CucumberException(e);
        }
        catch (InvocationTargetException e) {
            throw new CucumberException(e);
        }
        catch (IllegalAccessException e) {
            throw new CucumberException(e);
        }
    }
}

