/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.runtime.CucumberException;
import cucumber.runtime.formatter.StrictAware;
import cucumber.runtime.io.URLOutputStream;
import cucumber.runtime.io.UTF8OutputStreamWriter;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class JUnitFormatter
implements Formatter,
Reporter,
StrictAware {
    private final Writer out;
    private final Document doc;
    private final Element rootElement;
    private TestCase testCase;
    private Element root;

    public JUnitFormatter(URL out) throws IOException {
        this.out = new UTF8OutputStreamWriter(new URLOutputStream(out));
        TestCase.treatSkippedAsFailure = false;
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.rootElement = this.doc.createElement("testsuite");
            this.doc.appendChild(this.rootElement);
        }
        catch (ParserConfigurationException e) {
            throw new CucumberException("Error while processing unit report", e);
        }
    }

    public void feature(Feature feature) {
        TestCase.feature = feature;
        TestCase.previousScenarioOutlineName = "";
        TestCase.exampleNumber = 1;
    }

    public void background(Background background) {
        if (!this.isCurrentTestCaseCreatedNameless()) {
            this.testCase = new TestCase();
            this.root = this.testCase.createElement(this.doc);
        }
    }

    public void scenario(Scenario scenario) {
        if (this.isCurrentTestCaseCreatedNameless()) {
            this.testCase.scenario = scenario;
        } else {
            this.testCase = new TestCase(scenario);
            this.root = this.testCase.createElement(this.doc);
        }
        this.testCase.writeElement(this.doc, this.root);
        this.rootElement.appendChild(this.root);
        this.increaseAttributeValue(this.rootElement, "tests");
    }

    private boolean isCurrentTestCaseCreatedNameless() {
        return this.testCase != null && this.testCase.scenario == null;
    }

    public void step(Step step) {
        if (this.testCase != null) {
            this.testCase.steps.add(step);
        }
    }

    public void done() {
        try {
            this.rootElement.setAttribute("name", JUnitFormatter.class.getName());
            this.rootElement.setAttribute("failures", String.valueOf(this.rootElement.getElementsByTagName("failure").getLength()));
            this.rootElement.setAttribute("skipped", String.valueOf(this.rootElement.getElementsByTagName("skipped").getLength()));
            this.rootElement.setAttribute("time", this.sumTimes(this.rootElement.getElementsByTagName("testcase")));
            if (this.rootElement.getElementsByTagName("testcase").getLength() == 0) {
                this.addDummyTestCase();
            }
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(this.out);
            DOMSource source = new DOMSource(this.doc);
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            throw new CucumberException("Error while transforming.", e);
        }
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
    }

    private void addDummyTestCase() {
        Element dummy = this.doc.createElement("testcase");
        dummy.setAttribute("classname", "dummy");
        dummy.setAttribute("name", "dummy");
        this.rootElement.appendChild(dummy);
        Element skipped = this.doc.createElement("skipped");
        skipped.setAttribute("message", "No features found");
        dummy.appendChild(skipped);
    }

    public void result(Result result) {
        this.testCase.results.add(result);
        this.testCase.updateElement(this.doc, this.root);
    }

    public void before(Match match, Result result) {
        if (!this.isCurrentTestCaseCreatedNameless()) {
            this.testCase = new TestCase();
            this.root = this.testCase.createElement(this.doc);
        }
        this.handleHook(result);
    }

    public void after(Match match, Result result) {
        this.handleHook(result);
    }

    private void handleHook(Result result) {
        this.testCase.hookResults.add(result);
        this.testCase.updateElement(this.doc, this.root);
    }

    private String sumTimes(NodeList testCaseNodes) {
        double totalDurationSecondsForAllTimes = 0.0;
        for (int i = 0; i < testCaseNodes.getLength(); ++i) {
            try {
                double testCaseTime = Double.parseDouble(testCaseNodes.item(i).getAttributes().getNamedItem("time").getNodeValue());
                totalDurationSecondsForAllTimes += testCaseTime;
                continue;
            }
            catch (NumberFormatException e) {
                throw new CucumberException(e);
            }
            catch (NullPointerException e) {
                throw new CucumberException(e);
            }
        }
        DecimalFormat nfmt = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        nfmt.applyPattern("0.######");
        return nfmt.format(totalDurationSecondsForAllTimes);
    }

    private void increaseAttributeValue(Element element, String attribute) {
        int value = 0;
        if (element.hasAttribute(attribute)) {
            value = Integer.parseInt(element.getAttribute(attribute));
        }
        element.setAttribute(attribute, String.valueOf(++value));
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.testCase = null;
    }

    public void examples(Examples examples) {
    }

    public void match(Match match) {
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
    }

    public void uri(String uri) {
    }

    public void close() {
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    @Override
    public void setStrict(boolean strict) {
        TestCase.treatSkippedAsFailure = strict;
    }

    private static class TestCase {
        private static final DecimalFormat NUMBER_FORMAT = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        Scenario scenario;
        static Feature feature;
        static String previousScenarioOutlineName;
        static int exampleNumber;
        static boolean treatSkippedAsFailure;
        final List<Step> steps = new ArrayList<Step>();
        final List<Result> results = new ArrayList<Result>();
        final List<Result> hookResults = new ArrayList<Result>();

        private TestCase(Scenario scenario) {
            this.scenario = scenario;
        }

        private TestCase() {
        }

        private Element createElement(Document doc) {
            return doc.createElement("testcase");
        }

        private void writeElement(Document doc, Element tc) {
            tc.setAttribute("classname", feature.getName());
            tc.setAttribute("name", this.calculateElementName(this.scenario));
        }

        private String calculateElementName(Scenario scenario) {
            String scenarioName = scenario.getName();
            if (scenario.getKeyword().equals("Scenario Outline") && scenarioName.equals(previousScenarioOutlineName)) {
                return scenarioName + (this.includesBlank(scenarioName) ? " " : "_") + ++exampleNumber;
            }
            previousScenarioOutlineName = scenario.getKeyword().equals("Scenario Outline") ? scenarioName : "";
            exampleNumber = 1;
            return scenarioName;
        }

        private boolean includesBlank(String scenarioName) {
            return scenarioName.indexOf(32) != -1;
        }

        public void updateElement(Document doc, Element tc) {
            Element child;
            tc.setAttribute("time", this.calculateTotalDurationString());
            StringBuilder sb = new StringBuilder();
            this.addStepAndResultListing(sb);
            Result skipped = null;
            Result failed = null;
            for (Result result : this.results) {
                if ("failed".equals(result.getStatus())) {
                    failed = result;
                }
                if (!"undefined".equals(result.getStatus()) && !"pending".equals(result.getStatus())) continue;
                skipped = result;
            }
            for (Result result : this.hookResults) {
                if (failed != null || !"failed".equals(result.getStatus())) continue;
                failed = result;
            }
            if (failed != null) {
                this.addStackTrace(sb, failed);
                child = this.createElementWithMessage(doc, sb, "failure", failed.getErrorMessage());
            } else {
                child = skipped != null ? (treatSkippedAsFailure ? this.createElementWithMessage(doc, sb, "failure", "The scenario has pending or undefined step(s)") : this.createElement(doc, sb, "skipped")) : this.createElement(doc, sb, "system-out");
            }
            Node existingChild = tc.getFirstChild();
            if (existingChild == null) {
                tc.appendChild(child);
            } else {
                tc.replaceChild(child, existingChild);
            }
        }

        private String calculateTotalDurationString() {
            long totalDurationNanos = 0L;
            for (Result r : this.results) {
                totalDurationNanos += r.getDuration() == null ? 0L : r.getDuration();
            }
            for (Result r : this.hookResults) {
                totalDurationNanos += r.getDuration() == null ? 0L : r.getDuration();
            }
            double totalDurationSeconds = (double)totalDurationNanos / 1.0E9;
            return NUMBER_FORMAT.format(totalDurationSeconds);
        }

        private void addStepAndResultListing(StringBuilder sb) {
            for (int i = 0; i < this.steps.size(); ++i) {
                int length = sb.length();
                String resultStatus = "not executed";
                if (i < this.results.size()) {
                    resultStatus = this.results.get(i).getStatus();
                }
                sb.append(this.steps.get(i).getKeyword());
                sb.append(this.steps.get(i).getName());
                do {
                    sb.append(".");
                } while (sb.length() - length < 76);
                sb.append(resultStatus);
                sb.append("\n");
            }
        }

        private void addStackTrace(StringBuilder sb, Result failed) {
            sb.append("\nStackTrace:\n");
            StringWriter sw = new StringWriter();
            failed.getError().printStackTrace(new PrintWriter(sw));
            sb.append(sw.toString());
        }

        private Element createElementWithMessage(Document doc, StringBuilder sb, String elementType, String message) {
            Element child = this.createElement(doc, sb, elementType);
            child.setAttribute("message", message);
            return child;
        }

        private Element createElement(Document doc, StringBuilder sb, String elementType) {
            Element child = doc.createElement(elementType);
            child.appendChild(doc.createCDATASection(sb.toString()));
            return child;
        }

        static {
            NUMBER_FORMAT.applyPattern("0.######");
            treatSkippedAsFailure = false;
        }
    }
}

