/*
 * Decompiled with CFR 0.152.
 */
package io.github.netmikey.logunit.log4j2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.event.Level;

public class LevelMapper {
    private static final Map<Level, org.apache.logging.log4j.Level> LEVEL_MAPPING;
    private static final Map<org.apache.logging.log4j.Level, Level> LEVEL_MAPPING_REVERSE;

    public static org.apache.logging.log4j.Level mapLevel(Level level) {
        org.apache.logging.log4j.Level result = LEVEL_MAPPING.get(level);
        if (result == null) {
            throw new IllegalArgumentException("Cannot map log level " + level + " to a log4j2 log level");
        }
        return result;
    }

    public static Level mapLevel(org.apache.logging.log4j.Level level) {
        Level result = LEVEL_MAPPING_REVERSE.get(level);
        if (result == null) {
            throw new IllegalArgumentException("Cannot map log4j2 log level " + level + " to an slf4j log level");
        }
        return result;
    }

    static {
        HashMap<Level, org.apache.logging.log4j.Level> levelMapping = new HashMap<Level, org.apache.logging.log4j.Level>();
        levelMapping.put(Level.TRACE, org.apache.logging.log4j.Level.TRACE);
        levelMapping.put(Level.DEBUG, org.apache.logging.log4j.Level.DEBUG);
        levelMapping.put(Level.INFO, org.apache.logging.log4j.Level.INFO);
        levelMapping.put(Level.WARN, org.apache.logging.log4j.Level.WARN);
        levelMapping.put(Level.ERROR, org.apache.logging.log4j.Level.ERROR);
        LEVEL_MAPPING = Collections.unmodifiableMap(levelMapping);
        HashMap<org.apache.logging.log4j.Level, Level> levelMappingReverse = new HashMap<org.apache.logging.log4j.Level, Level>();
        levelMapping.forEach((key, value) -> levelMappingReverse.put((org.apache.logging.log4j.Level)value, (Level)key));
        levelMappingReverse.put(org.apache.logging.log4j.Level.ALL, Level.TRACE);
        levelMappingReverse.put(org.apache.logging.log4j.Level.FATAL, Level.ERROR);
        levelMappingReverse.put(org.apache.logging.log4j.Level.OFF, Level.ERROR);
        LEVEL_MAPPING_REVERSE = Collections.unmodifiableMap(levelMappingReverse);
    }
}

