/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import javax.annotation.Nullable;

public final class HttpSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private final HttpCommonAttributesExtractor<REQUEST, ?> attributesExtractor;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(HttpCommonAttributesExtractor<REQUEST, ?> attributesExtractor) {
        return new HttpSpanNameExtractor<REQUEST>(attributesExtractor);
    }

    private HttpSpanNameExtractor(HttpCommonAttributesExtractor<REQUEST, ?> attributesExtractor) {
        this.attributesExtractor = attributesExtractor;
    }

    @Override
    public String extract(REQUEST request) {
        String route = this.extractRoute(request);
        if (route != null) {
            return route;
        }
        String method = this.attributesExtractor.method(request);
        if (method != null) {
            return "HTTP " + method;
        }
        return "HTTP request";
    }

    @Nullable
    private String extractRoute(REQUEST request) {
        if (this.attributesExtractor instanceof HttpServerAttributesExtractor) {
            return ((HttpServerAttributesExtractor)this.attributesExtractor).route(request);
        }
        return null;
    }
}

