/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilderMonitor;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class TinyBuilder
extends Builder {
    public static final int PARENT_POINTER_INTERVAL = 10;
    private TinyTree tree;
    private int currentDepth = 0;
    private int nodeNr = 0;
    private boolean ended = false;
    private Statistics statistics;
    private boolean markDefaultedAttributes = false;
    private int textualElementEligibilityState = 0;
    private int[] prevAtDepth = new int[100];
    private int[] siblingsAtDepth = new int[100];
    private boolean isIDElement = false;

    public TinyBuilder(PipelineConfiguration pipe) {
        super(pipe);
        Configuration config = pipe.getConfiguration();
        this.statistics = config.getTreeStatistics().TEMPORARY_TREE_STATISTICS;
        this.markDefaultedAttributes = config.isExpandAttributeDefaults() && config.getBooleanProperty(Feature.MARK_DEFAULTED_ATTRIBUTES);
    }

    public void setStatistics(Statistics stats) {
        this.statistics = stats;
    }

    public TinyTree getTree() {
        return this.tree;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    @Override
    public void open() {
        if (this.started) {
            return;
        }
        if (this.tree == null) {
            this.tree = new TinyTree(this.config, this.statistics);
            this.currentDepth = 0;
            if (this.lineNumbering) {
                this.tree.setLineNumbering();
            }
        }
        super.open();
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        int nodeNr;
        if (this.started && !this.ended || this.currentDepth > 0) {
            return;
        }
        this.started = true;
        this.ended = false;
        TinyTree tt = this.tree;
        assert (tt != null);
        this.currentRoot = new TinyDocumentImpl(tt);
        TinyDocumentImpl doc = (TinyDocumentImpl)this.currentRoot;
        doc.setSystemId(this.getSystemId());
        doc.setBaseURI(this.getBaseURI());
        this.currentDepth = 0;
        this.prevAtDepth[0] = nodeNr = tt.addDocumentNode((TinyDocumentImpl)this.currentRoot);
        this.prevAtDepth[1] = -1;
        this.siblingsAtDepth[0] = 0;
        this.siblingsAtDepth[1] = 0;
        tt.next[nodeNr] = -1;
        ++this.currentDepth;
    }

    @Override
    public void endDocument() throws XPathException {
        this.tree.addNode((short)11, 0, 0, 0, -1);
        --this.tree.numberOfNodes;
        if (this.currentDepth > 1) {
            return;
        }
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.prevAtDepth[this.currentDepth] = -1;
        --this.currentDepth;
    }

    @Override
    public void reset() {
        super.reset();
        this.tree = null;
        this.currentDepth = 0;
        this.nodeNr = 0;
        this.ended = false;
        this.statistics = this.config.getTreeStatistics().TEMPORARY_TREE_STATISTICS;
    }

    @Override
    public void close() throws XPathException {
        TinyTree tt = this.tree;
        if (tt != null) {
            tt.addNode((short)11, 0, 0, 0, -1);
            tt.condense(this.statistics);
        }
        super.close();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, Location location, int properties) throws XPathException {
        TinyTree tt = this.tree;
        assert (tt != null);
        this.textualElementEligibilityState = 0;
        if (this.siblingsAtDepth[this.currentDepth] > 10) {
            this.nodeNr = tt.addNode((short)12, this.currentDepth, this.prevAtDepth[this.currentDepth - 1], 0, 0);
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                tt.next[prev] = this.nodeNr;
            }
            tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            this.siblingsAtDepth[this.currentDepth] = 0;
        }
        int fp = elemName.obtainFingerprint(this.namePool);
        int prefixCode = this.tree.prefixPool.obtainPrefixCode(elemName.getPrefix());
        int nameCode = prefixCode << 20 | fp;
        this.nodeNr = tt.addNode((short)1, this.currentDepth, -1, -1, nameCode);
        this.isIDElement = (properties & 0x800) != 0;
        int typeCode = type.getFingerprint();
        if (typeCode != 630) {
            tt.setElementAnnotation(this.nodeNr, type);
            if ((properties & 0x10) != 0) {
                tt.setNilled(this.nodeNr);
            }
            if (!this.isIDElement && type.isIdType()) {
                this.isIDElement = true;
            }
        }
        if (this.currentDepth == 0) {
            this.prevAtDepth[0] = this.nodeNr;
            this.prevAtDepth[1] = -1;
            this.currentRoot = tt.getNode(this.nodeNr);
        } else {
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                tt.next[prev] = this.nodeNr;
            }
            tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n = this.currentDepth;
            this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
        }
        ++this.currentDepth;
        if (this.currentDepth == this.prevAtDepth.length) {
            this.prevAtDepth = Arrays.copyOf(this.prevAtDepth, this.currentDepth * 2);
            this.siblingsAtDepth = Arrays.copyOf(this.siblingsAtDepth, this.currentDepth * 2);
        }
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        if (this.isUseEventLocation() && location.getSystemId() != null) {
            tt.setSystemId(this.nodeNr, location.getSystemId());
        } else if (this.currentDepth == 1) {
            tt.setSystemId(this.nodeNr, this.systemId);
        }
        if (this.lineNumbering) {
            tt.setLineNumber(this.nodeNr, location.getLineNumber(), location.getColumnNumber());
        }
        if (location instanceof ReceivingContentHandler.LocalLocator && ((ReceivingContentHandler.LocalLocator)location).levelInEntity == 0 && this.currentDepth >= 1) {
            tt.markTopWithinEntity(this.nodeNr);
        }
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        assert (this.tree != null);
        for (NamespaceBinding ns : namespaceBindings) {
            this.tree.addNamespace(this.nodeNr, ns);
        }
    }

    @Override
    public void attribute(NodeName attName, SimpleType type, CharSequence value, Location locationId, int properties) throws XPathException {
        int nameCode;
        int fp = attName.obtainFingerprint(this.namePool);
        String prefix = attName.getPrefix();
        int n = nameCode = prefix.isEmpty() ? fp : this.tree.prefixPool.obtainPrefixCode(prefix) << 20 | fp;
        assert (this.tree != null);
        assert (this.currentRoot != null);
        this.tree.addAttribute(this.currentRoot, this.nodeNr, nameCode, type, value, properties);
        if (this.markDefaultedAttributes && (properties & 8) != 0) {
            this.tree.markDefaultedAttribute(this.tree.numberOfAttributes - 1);
        }
    }

    @Override
    public void startContent() {
        ++this.nodeNr;
        this.textualElementEligibilityState = 1;
    }

    @Override
    public void endElement() throws XPathException {
        assert (this.tree != null);
        boolean eligibleAsTextualElement = this.textualElementEligibilityState == 2;
        this.textualElementEligibilityState = 0;
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        --this.currentDepth;
        if (this.isIDElement) {
            this.tree.indexIDElement(this.currentRoot, this.prevAtDepth[this.currentDepth]);
            this.isIDElement = false;
        } else if (eligibleAsTextualElement && this.tree.nodeKind[this.nodeNr] == 3 && this.tree.nodeKind[this.nodeNr - 1] == 1 && this.tree.alpha[this.nodeNr - 1] == -1 && this.tree.beta[this.nodeNr - 1] == -1) {
            this.tree.nodeKind[this.nodeNr - 1] = 17;
            this.tree.alpha[this.nodeNr - 1] = this.tree.alpha[this.nodeNr];
            this.tree.beta[this.nodeNr - 1] = this.tree.beta[this.nodeNr];
            --this.nodeNr;
            --this.tree.numberOfNodes;
            if (this.currentDepth == 0) {
                this.currentRoot = this.tree.getNode(this.nodeNr);
            }
        }
    }

    public TinyNodeImpl getLastCompletedElement() {
        if (this.tree == null) {
            return null;
        }
        return this.tree.getNode(this.currentDepth >= 0 ? this.prevAtDepth[this.currentDepth] : 0);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (chars instanceof CompressedWhitespace && (properties & 0x400) != 0) {
            TinyTree tt = this.tree;
            assert (tt != null);
            long lvalue = ((CompressedWhitespace)chars).getCompressedValue();
            this.nodeNr = tt.addNode((short)4, this.currentDepth, (int)(lvalue >> 32), (int)lvalue, -1);
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                tt.next[prev] = this.nodeNr;
            }
            tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n = this.currentDepth;
            this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
            if (this.lineNumbering) {
                tt.setLineNumber(this.nodeNr, locationId.getLineNumber(), locationId.getColumnNumber());
            }
            return;
        }
        int len = chars.length();
        if (len > 0) {
            this.nodeNr = this.makeTextNode(chars, len);
            if (this.lineNumbering) {
                this.tree.setLineNumber(this.nodeNr, locationId.getLineNumber(), locationId.getColumnNumber());
            }
            this.textualElementEligibilityState = this.textualElementEligibilityState == 1 ? 2 : 0;
        }
    }

    protected int makeTextNode(CharSequence chars, int len) {
        TinyTree tt = this.tree;
        assert (tt != null);
        int bufferStart = tt.getCharacterBuffer().length();
        tt.appendChars(chars);
        int n = tt.numberOfNodes - 1;
        if (tt.nodeKind[n] == 3 && tt.depth[n] == this.currentDepth) {
            int n2 = n;
            tt.beta[n2] = tt.beta[n2] + len;
        } else {
            this.nodeNr = tt.addNode((short)3, this.currentDepth, bufferStart, len, -1);
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                tt.next[prev] = this.nodeNr;
            }
            tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n3 = this.currentDepth;
            this.siblingsAtDepth[n3] = this.siblingsAtDepth[n3] + 1;
        }
        return this.nodeNr;
    }

    @Override
    public void processingInstruction(String piname, CharSequence remainder, Location locationId, int properties) throws XPathException {
        TinyTree tt = this.tree;
        assert (tt != null);
        this.textualElementEligibilityState = 0;
        if (tt.commentBuffer == null) {
            tt.commentBuffer = new FastStringBuffer(256);
        }
        int s = tt.commentBuffer.length();
        tt.commentBuffer.append(remainder.toString());
        int nameCode = this.namePool.allocateFingerprint("", piname);
        this.nodeNr = tt.addNode((short)7, this.currentDepth, s, remainder.length(), nameCode);
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            tt.next[prev] = this.nodeNr;
        }
        tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n = this.currentDepth;
        this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
        tt.setSystemId(this.nodeNr, locationId.getSystemId());
        if (this.lineNumbering) {
            tt.setLineNumber(this.nodeNr, locationId.getLineNumber(), locationId.getColumnNumber());
        }
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        TinyTree tt = this.tree;
        assert (tt != null);
        this.textualElementEligibilityState = 0;
        if (tt.commentBuffer == null) {
            tt.commentBuffer = new FastStringBuffer(256);
        }
        int s = tt.commentBuffer.length();
        tt.commentBuffer.append(chars.toString());
        this.nodeNr = tt.addNode((short)8, this.currentDepth, s, chars.length(), -1);
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            tt.next[prev] = this.nodeNr;
        }
        tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n = this.currentDepth;
        this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
        if (this.lineNumbering) {
            tt.setLineNumber(this.nodeNr, locationId.getLineNumber(), locationId.getColumnNumber());
        }
    }

    @Override
    public void setUnparsedEntity(String name, String uri, String publicId) {
        if (this.tree.getUnparsedEntity(name) == null) {
            this.tree.setUnparsedEntity(name, uri, publicId);
        }
    }

    @Override
    public BuilderMonitor getBuilderMonitor() {
        return new TinyBuilderMonitor(this);
    }

    public boolean isPositionedAtElement() {
        return this.tree.numberOfNodes > 0 && (this.tree.nodeKind[this.tree.numberOfNodes - 1] & 0xF) == 1;
    }

    public void bulkCopy(TinyElementImpl sourceNode, boolean copyNamespaces) {
        TinyTree sourceTree = sourceNode.tree;
        int oldNodeNr = sourceNode.nodeNr;
        int newNodeNr = this.tree.numberOfNodes;
        this.tree.bulkCopy(sourceTree, oldNodeNr, this.currentDepth);
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            this.tree.next[prev] = newNodeNr;
        }
        this.tree.next[newNodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = newNodeNr;
        int n = this.currentDepth;
        this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
    }

    public void graft(NodeInfo node, boolean copyNamespaces) {
        int newNodeNr = this.tree.numberOfNodes;
        this.tree.graft(node, newNodeNr, this.currentDepth, copyNamespaces);
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            this.tree.next[prev] = newNodeNr;
        }
        this.tree.next[newNodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = newNodeNr;
        int n = this.currentDepth;
        this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
    }
}

