/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.rule.AbstractIgnoredAnnotationRule;

public class AbstractLombokAwareRule
extends AbstractIgnoredAnnotationRule {
    private boolean lombokImported = false;
    private boolean classHasLombokAnnotation = false;
    private static final String LOMBOK_PACKAGE = "lombok";
    private static final Set<String> LOMBOK_ANNOTATIONS = new HashSet<String>();

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return LOMBOK_ANNOTATIONS;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.lombokImported = false;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        ASTName name = (ASTName)node.getFirstChildOfType(ASTName.class);
        if (!this.lombokImported && name != null && name.getImage() != null & name.getImage().startsWith(LOMBOK_PACKAGE)) {
            this.lombokImported = true;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        boolean oldValue = this.classHasLombokAnnotation;
        this.classHasLombokAnnotation = this.hasLombokAnnotation(node);
        Object result = super.visit(node, data);
        this.classHasLombokAnnotation = oldValue;
        return result;
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        boolean oldValue = this.classHasLombokAnnotation;
        this.classHasLombokAnnotation = this.hasLombokAnnotation(node);
        Object result = super.visit(node, data);
        this.classHasLombokAnnotation = oldValue;
        return result;
    }

    protected boolean hasClassLombokAnnotation() {
        return this.classHasLombokAnnotation;
    }

    @Deprecated
    protected boolean hasLombokAnnotation(Node node) {
        boolean result = false;
        Node parent = node.getParent();
        List annotations = parent.findChildrenOfType(ASTAnnotation.class);
        for (ASTAnnotation annotation : annotations) {
            String shortName;
            ASTName name = (ASTName)annotation.getFirstDescendantOfType(ASTName.class);
            if (name == null) continue;
            String annotationName = name.getImage();
            if (this.lombokImported) {
                if (!LOMBOK_ANNOTATIONS.contains(annotationName)) continue;
                result = true;
                continue;
            }
            if (!annotationName.startsWith("lombok.") || !LOMBOK_ANNOTATIONS.contains(shortName = annotationName.substring(LOMBOK_PACKAGE.length() + 1))) continue;
            result = true;
        }
        return result;
    }

    protected boolean hasLombokAnnotation(Annotatable node) {
        return node.isAnyAnnotationPresent(LOMBOK_ANNOTATIONS);
    }

    static {
        LOMBOK_ANNOTATIONS.add("lombok.Data");
        LOMBOK_ANNOTATIONS.add("lombok.Getter");
        LOMBOK_ANNOTATIONS.add("lombok.Setter");
        LOMBOK_ANNOTATIONS.add("lombok.Value");
        LOMBOK_ANNOTATIONS.add("lombok.RequiredArgsConstructor");
        LOMBOK_ANNOTATIONS.add("lombok.AllArgsConstructor");
        LOMBOK_ANNOTATIONS.add("lombok.NoArgsConstructor");
        LOMBOK_ANNOTATIONS.add("lombok.Builder");
    }
}

