/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTResourceSpecification;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.jaxen.JaxenException;

public class CloseResourceRule
extends AbstractJavaRule {
    private Set<String> types = new HashSet<String>();
    private Set<String> simpleTypes = new HashSet<String>();
    private Set<String> closeTargets = new HashSet<String>();
    private static final PropertyDescriptor<List<String>> CLOSE_TARGETS_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"closeTargets").desc("Methods which may close this resource")).emptyDefaultValue().delim(',').build();
    private static final PropertyDescriptor<List<String>> TYPES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"types").desc("Affected types")).defaultValues((Object)"java.lang.AutoCloseable", (Object[])new String[]{"java.sql.Connection", "java.sql.Statement", "java.sql.ResultSet"}).delim(',').build();
    private static final PropertyDescriptor<Boolean> USE_CLOSE_AS_DEFAULT_TARGET = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"closeAsDefaultTarget").desc("Consider 'close' as a target by default")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<List<String>> ALLOWED_RESOURCE_TYPES = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"allowedResourceTypes").desc("Exact class names that do not need to be closed")).defaultValues((Object)"java.io.ByteArrayOutputStream", (Object[])new String[]{"java.io.ByteArrayInputStream", "java.io.StringWriter", "java.io.CharArrayWriter", "java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream"}).build();

    public CloseResourceRule() {
        this.definePropertyDescriptor(CLOSE_TARGETS_DESCRIPTOR);
        this.definePropertyDescriptor(TYPES_DESCRIPTOR);
        this.definePropertyDescriptor(USE_CLOSE_AS_DEFAULT_TARGET);
        this.definePropertyDescriptor(ALLOWED_RESOURCE_TYPES);
    }

    public void start(RuleContext ctx) {
        this.closeTargets.clear();
        this.simpleTypes.clear();
        this.types.clear();
        if (this.getProperty(CLOSE_TARGETS_DESCRIPTOR) != null) {
            this.closeTargets.addAll((Collection)this.getProperty(CLOSE_TARGETS_DESCRIPTOR));
        }
        if (((Boolean)this.getProperty(USE_CLOSE_AS_DEFAULT_TARGET)).booleanValue() && !this.closeTargets.contains("close")) {
            this.closeTargets.add("close");
        }
        if (this.getProperty(TYPES_DESCRIPTOR) != null) {
            this.types.addAll((Collection)this.getProperty(TYPES_DESCRIPTOR));
            for (String type : (List)this.getProperty(TYPES_DESCRIPTOR)) {
                this.simpleTypes.add(CloseResourceRule.toSimpleType(type));
            }
        }
    }

    private static String toSimpleType(String fullyQualifiedClassName) {
        int lastIndexOf = fullyQualifiedClassName.lastIndexOf(46);
        if (lastIndexOf > -1) {
            return fullyQualifiedClassName.substring(lastIndexOf + 1);
        }
        return fullyQualifiedClassName;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.checkForResources(node, data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        this.checkForResources(node, data);
        return super.visit(node, data);
    }

    private void checkForResources(ASTMethodOrConstructorDeclaration node, Object data) {
        List localVars = node.findDescendantsOfType(ASTLocalVariableDeclaration.class);
        ArrayList vars = new ArrayList();
        HashMap<ASTVariableDeclaratorId, ASTType> ids = new HashMap<ASTVariableDeclaratorId, ASTType>();
        for (ASTLocalVariableDeclaration aSTLocalVariableDeclaration : localVars) {
            vars.addAll(aSTLocalVariableDeclaration.findChildrenOfType(ASTVariableDeclarator.class));
        }
        for (ASTVariableDeclarator aSTVariableDeclarator : vars) {
            AbstractJavaTypeNode type = ((ASTLocalVariableDeclaration)aSTVariableDeclarator.getParent()).getTypeNode();
            if (type == null || !this.isResourceTypeOrSubtype(type)) continue;
            if (aSTVariableDeclarator.hasInitializer()) {
                ASTExpression firstArgument;
                ASTExpression expression;
                ASTExpression runtimeType = expression = (ASTExpression)aSTVariableDeclarator.getInitializer().getFirstChildOfType(ASTExpression.class);
                if (!this.isMethodCall(expression) && runtimeType != null && runtimeType.getType() != null) {
                    type = runtimeType;
                }
                if ((firstArgument = this.getAllocationFirstArgument(expression)) != null) {
                    type = firstArgument;
                }
            }
            if (this.isAllowedResourceType(type) || this.isMethodParameter(aSTVariableDeclarator, node)) continue;
            ids.put(aSTVariableDeclarator.getVariableId(), (ASTType)type);
        }
        for (Map.Entry entry : ids.entrySet()) {
            ASTVariableDeclaratorId variableId = (ASTVariableDeclaratorId)entry.getKey();
            this.ensureClosed((ASTLocalVariableDeclaration)((JavaNode)variableId.getParent()).getParent(), variableId, (TypeNode)entry.getValue(), data);
        }
    }

    private boolean isMethodParameter(ASTVariableDeclarator var, ASTMethodOrConstructorDeclaration methodOrCstor) {
        if (!var.hasInitializer()) {
            return false;
        }
        boolean result = false;
        ASTVariableInitializer initializer = var.getInitializer();
        ASTName name = (ASTName)initializer.getFirstDescendantOfType(ASTName.class);
        if (name != null) {
            ASTFormalParameters formalParameters = null;
            if (methodOrCstor instanceof ASTMethodDeclaration) {
                formalParameters = ((ASTMethodDeclaration)methodOrCstor).getFormalParameters();
            } else if (methodOrCstor instanceof ASTConstructorDeclaration) {
                formalParameters = ((ASTConstructorDeclaration)methodOrCstor).getFormalParameters();
            }
            if (formalParameters != null) {
                List ids = formalParameters.findDescendantsOfType(ASTVariableDeclaratorId.class);
                for (ASTVariableDeclaratorId id : ids) {
                    if (!id.hasImageEqualTo(name.getImage()) || !this.isResourceTypeOrSubtype(id)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private ASTExpression getAllocationFirstArgument(ASTExpression expression) {
        ASTArgumentList argumentList;
        List allocations = expression.findDescendantsOfType(ASTAllocationExpression.class);
        AbstractJavaNode firstArgument = null;
        if (!allocations.isEmpty() && (argumentList = (ASTArgumentList)((ASTAllocationExpression)allocations.get(allocations.size() - 1)).getFirstDescendantOfType(ASTArgumentList.class)) != null) {
            firstArgument = (ASTExpression)argumentList.getFirstChildOfType(ASTExpression.class);
        }
        if (firstArgument != null && firstArgument.getFirstDescendantOfType(ASTName.class) != null) {
            ASTName name = (ASTName)firstArgument.getFirstDescendantOfType(ASTName.class);
            Map vars = firstArgument.getScope().getDeclarations(VariableNameDeclaration.class);
            for (VariableNameDeclaration nameDecl : vars.keySet()) {
                if (!nameDecl.getName().equals(name.getImage()) || !this.isResourceTypeOrSubtype((TypeNode)((Object)firstArgument))) continue;
                return firstArgument;
            }
        }
        return null;
    }

    private boolean isMethodCall(ASTExpression expression) {
        return expression != null && expression.getNumChildren() > 0 && expression.getChild(0) instanceof ASTPrimaryExpression && ((JavaNode)expression.getChild(0)).getFirstChildOfType(ASTPrimarySuffix.class) != null;
    }

    private boolean isResourceTypeOrSubtype(TypeNode refType) {
        ASTClassOrInterfaceType clazz;
        ASTReferenceType ref;
        if (refType.getType() != null) {
            for (String type : this.types) {
                if (!TypeHelper.isA(refType, type)) continue;
                return true;
            }
        } else if (refType.getNumChildren() > 0 && refType.getChild(0) instanceof ASTReferenceType && (ref = (ASTReferenceType)refType.getChild(0)).getChild(0) instanceof ASTClassOrInterfaceType && (this.simpleTypes.contains(CloseResourceRule.toSimpleType((clazz = (ASTClassOrInterfaceType)ref.getChild(0)).getImage())) && !clazz.isReferenceToClassSameCompilationUnit() || this.types.contains(clazz.getImage()) && !clazz.isReferenceToClassSameCompilationUnit())) {
            return true;
        }
        return false;
    }

    private boolean isAllowedResourceType(TypeNode refType) {
        List allowedResourceTypes = (List)this.getProperty(ALLOWED_RESOURCE_TYPES);
        if (refType.getType() != null && allowedResourceTypes != null) {
            for (String type : allowedResourceTypes) {
                if (!TypeHelper.isExactlyA(refType, type)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNullInitializer(ASTLocalVariableDeclaration var) {
        ASTVariableInitializer init = (ASTVariableInitializer)var.getFirstDescendantOfType(ASTVariableInitializer.class);
        if (init != null) {
            try {
                List nulls = init.findChildNodesWithXPath("Expression/PrimaryExpression/PrimaryPrefix/Literal/NullLiteral");
                return !nulls.isEmpty();
            }
            catch (JaxenException e) {
                return false;
            }
        }
        return false;
    }

    private void ensureClosed(ASTLocalVariableDeclaration var, ASTVariableDeclaratorId id, TypeNode type, Object data) {
        String variableToClose = id.getImage();
        ASTLocalVariableDeclaration n = var;
        while (!(n instanceof ASTBlock) && !(n instanceof ASTConstructorDeclaration)) {
            n = n.getParent();
        }
        ASTLocalVariableDeclaration top = n;
        List tryblocks = top.findDescendantsOfType(ASTTryStatement.class);
        boolean closed = false;
        ASTBlockStatement parentBlock = (ASTBlockStatement)id.getFirstParentOfType(ASTBlockStatement.class);
        block1: for (Object t : tryblocks) {
            ASTBlockStatement tryBlock = (ASTBlockStatement)t.getFirstParentOfType(ASTBlockStatement.class);
            if (!this.hasNullInitializer(var) && parentBlock.getParent() == tryBlock.getParent()) {
                List blocks = ((JavaNode)parentBlock.getParent()).findChildrenOfType(ASTBlockStatement.class);
                int parentBlockIndex = blocks.indexOf(parentBlock);
                int tryBlockIndex = blocks.indexOf(tryBlock);
                boolean criticalStatements = false;
                for (int i = parentBlockIndex + 1; i < tryBlockIndex; ++i) {
                    ASTBlockStatement block = (ASTBlockStatement)blocks.get(i);
                    ASTLocalVariableDeclaration varDecl = (ASTLocalVariableDeclaration)block.getFirstDescendantOfType(ASTLocalVariableDeclaration.class);
                    ASTStatementExpression statementExpression = (ASTStatementExpression)block.getFirstDescendantOfType(ASTStatementExpression.class);
                    if (varDecl != null || statementExpression != null && statementExpression.getFirstChildOfType(ASTAssignmentOperator.class) != null) continue;
                    criticalStatements = true;
                    break;
                }
                if (criticalStatements) break;
            }
            ASTFinallyStatement finallyClause = ((ASTTryStatement)t).getFinallyClause();
            if (t.getBeginLine() > id.getBeginLine() && finallyClause != null) {
                ASTBlock finallyBody = finallyClause.getBody();
                List names = finallyBody.findDescendantsOfType(ASTName.class);
                for (ASTName oName : names) {
                    String[] parts;
                    String name = oName.getImage();
                    if (name == null || !name.contains(".") || (parts = name.split("\\.")).length != 2) continue;
                    String methodName = parts[1];
                    String varName = parts[0];
                    if (!varName.equals(variableToClose) || !this.closeTargets.contains(methodName) || !this.nullCheckIfCondition(finallyBody, (Node)oName, varName)) continue;
                    closed = true;
                    break;
                }
                if (closed) break;
                List exprs = finallyBody.findDescendantsOfType(ASTStatementExpression.class, true);
                for (ASTStatementExpression stmt : exprs) {
                    ASTPrimarySuffix oSuffix;
                    String suff;
                    ASTName prefixName;
                    String prefixPlusSuffix;
                    ASTPrimaryExpression expr = (ASTPrimaryExpression)stmt.getFirstChildOfType(ASTPrimaryExpression.class);
                    if (expr == null) continue;
                    ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)expr.getFirstChildOfType(ASTPrimaryPrefix.class);
                    ASTPrimarySuffix suffix = (ASTPrimarySuffix)expr.getFirstChildOfType(ASTPrimarySuffix.class);
                    if (prefix == null || suffix == null) continue;
                    if (prefix.getImage() != null ? suffix.getImage() != null && this.closeTargets.contains(prefixPlusSuffix = prefix.getImage() + "." + suffix.getImage()) && (closed = this.variableIsPassedToMethod(expr, variableToClose)) : (prefixName = (ASTName)prefix.getFirstChildOfType(ASTName.class)) != null && this.closeTargets.contains(prefixName.getImage()) && (closed = this.variableIsPassedToMethod(expr, variableToClose))) break;
                    if (closed) continue;
                    List suffixes = expr.findDescendantsOfType(ASTPrimarySuffix.class, true);
                    Iterator iterator = suffixes.iterator();
                    while (!(!iterator.hasNext() || this.closeTargets.contains(suff = (oSuffix = (ASTPrimarySuffix)iterator.next()).getImage()) && (closed = this.variableIsPassedToMethod(expr, variableToClose)))) {
                    }
                }
                if (!closed) continue;
                break;
            }
            if (!((ASTTryStatement)t).isTryWithResources()) continue;
            List names = ((ASTResourceSpecification)t.getFirstChildOfType(ASTResourceSpecification.class)).findDescendantsOfType(ASTName.class);
            for (ASTName potentialUsage : names) {
                if (!potentialUsage.hasImageEqualTo(variableToClose)) continue;
                closed = true;
                continue block1;
            }
        }
        if (!closed) {
            List returns = top.findDescendantsOfType(ASTReturnStatement.class, true);
            for (ASTReturnStatement returnStatement : returns) {
                ASTName name = (ASTName)returnStatement.getFirstDescendantOfType(ASTName.class);
                if (name == null || !name.getImage().equals(variableToClose)) continue;
                closed = true;
                break;
            }
        }
        if (!closed) {
            ASTLocalVariableDeclaration localVarDecl = (ASTLocalVariableDeclaration)id.getFirstParentOfType(ASTLocalVariableDeclaration.class);
            Class<?> typeClass = type.getType();
            if (typeClass != null) {
                this.addViolation(data, (Node)id, typeClass.getSimpleName());
            } else if (localVarDecl != null && localVarDecl.getTypeNode() != null) {
                this.addViolation(data, (Node)id, localVarDecl.getTypeNode().getTypeImage());
            } else {
                this.addViolation(data, (Node)id, id.getVariableName());
            }
        }
    }

    private boolean variableIsPassedToMethod(ASTPrimaryExpression expr, String variable) {
        List methodParams = expr.findDescendantsOfType(ASTName.class, true);
        for (ASTName pName : methodParams) {
            String paramName = pName.getImage();
            ASTArgumentList parentParam = (ASTArgumentList)pName.getFirstParentOfType(ASTArgumentList.class);
            if (!paramName.equals(variable) || parentParam == null) continue;
            return true;
        }
        return false;
    }

    private ASTIfStatement findIfStatement(ASTBlock enclosingBlock, Node node) {
        ASTIfStatement ifStatement = (ASTIfStatement)node.getFirstParentOfType(ASTIfStatement.class);
        List allIfStatements = enclosingBlock.findDescendantsOfType(ASTIfStatement.class);
        if (ifStatement != null && allIfStatements.contains(ifStatement)) {
            return ifStatement;
        }
        return null;
    }

    private boolean nullCheckIfCondition(ASTBlock enclosingBlock, Node node, String varName) {
        ASTIfStatement ifStatement = this.findIfStatement(enclosingBlock, node);
        if (ifStatement != null) {
            try {
                List nodes = ifStatement.findChildNodesWithXPath("Expression/EqualityExpression[@Image='!=']  [PrimaryExpression/PrimaryPrefix/Name[@Image='" + varName + "']]  [PrimaryExpression/PrimaryPrefix/Literal/NullLiteral]");
                return !nodes.isEmpty();
            }
            catch (JaxenException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

