/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.http.server.DefaultConnectionListener;
import org.apache.axis2.transport.http.server.HttpConnectionManager;
import org.apache.axis2.transport.http.server.HttpFactory;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.axis2.transport.http.server.WorkerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.params.HttpParams;

public class SimpleHttpServer {
    private static Log LOG = LogFactory.getLog(SimpleHttpServer.class);
    private static final int SHUTDOWN_GRACE_PERIOD = 3000;
    private HttpFactory httpFactory;
    private int port;
    private final HttpParams params;
    private final WorkerFactory workerFactory;
    private IOProcessor listener = null;
    private ExecutorService listenerExecutor = null;
    private HttpConnectionManager connmanager = null;
    private ExecutorService requestExecutor = null;

    public SimpleHttpServer(ConfigurationContext configurationContext, WorkerFactory workerFactory, int port) throws IOException {
        this(new HttpFactory(configurationContext, port, workerFactory), port);
    }

    public SimpleHttpServer(HttpFactory httpFactory, int port) throws IOException {
        this.httpFactory = httpFactory;
        this.port = port;
        this.workerFactory = httpFactory.newRequestWorkerFactory();
        this.params = httpFactory.newRequestConnectionParams();
        this.params.setIntParameter("axis.listener.port", port);
    }

    public void init() throws IOException {
        this.requestExecutor = this.httpFactory.newRequestExecutor(this.port);
        this.connmanager = this.httpFactory.newRequestConnectionManager(this.requestExecutor, this.workerFactory, this.params);
        this.listenerExecutor = this.httpFactory.newListenerExecutor(this.port);
        this.listener = this.httpFactory.newRequestConnectionListener(this.port, this.connmanager, this.params);
    }

    public void destroy() throws IOException, InterruptedException {
        LOG.info((Object)"Shut down connection listener");
        this.listenerExecutor.shutdownNow();
        this.listener.destroy();
        this.listenerExecutor.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        if (!this.listenerExecutor.isTerminated()) {
            LOG.info((Object)"Force shut down connection listener");
            this.listener.destroy();
            this.listener = null;
        }
        LOG.info((Object)"Shut down HTTP processors");
        this.requestExecutor.shutdownNow();
        if (!Boolean.parseBoolean(System.getProperty("org.apache.axis2.transport.http.server.fastShutdown", "false"))) {
            this.requestExecutor.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        if (!this.requestExecutor.isTerminated()) {
            LOG.info((Object)"Force shut down HTTP processors");
            this.connmanager.shutdown();
            this.connmanager = null;
        }
        LOG.info((Object)"HTTP protocol handler shut down");
    }

    public void start() {
        DefaultConnectionListener listener = (DefaultConnectionListener)this.listener;
        this.listenerExecutor.execute(listener);
        try {
            listener.awaitSocketOpen();
            if (!listener.isDestroyed()) {
                this.port = listener.getPort();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isRunning() {
        return this.listenerExecutor != null && !this.listenerExecutor.isShutdown();
    }

    public int getPort() {
        return this.port;
    }
}

