/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.res;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.res.ResourceFileSystemConfigBuilder;

public class ResourceFileProvider
extends AbstractFileProvider {
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.DISPATCHER));
    private static final int BUFFER_SIZE = 80;

    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        StringBuilder buf = new StringBuilder(80);
        UriParser.extractScheme(VFS.getManager().getSchemes(), uri, buf);
        String resourceName = buf.toString();
        ClassLoader classLoader = ResourceFileSystemConfigBuilder.getInstance().getClassLoader(fileSystemOptions);
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        FileSystemException.requireNonNull(classLoader, "vfs.provider.url/badly-formed-uri.error", uri);
        URL url = classLoader.getResource(resourceName);
        FileSystemException.requireNonNull(url, "vfs.provider.url/badly-formed-uri.error", uri);
        return this.getContext().getFileSystemManager().resolveFile(url.toExternalForm());
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    @Override
    public void closeFileSystem(FileSystem filesystem) {
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

