/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.customization;

import java.util.Iterator;
import java.util.logging.Logger;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.CustomizationParser;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSClass;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSParameter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXWSBindingParser {
    private static final Logger LOG = LogUtils.getL7dLogger(CustomizationParser.class);
    private ExtensionRegistry extReg;

    public JAXWSBindingParser(ExtensionRegistry ext) {
        this.extReg = ext;
    }

    public JAXWSBinding parse(Class<?> parentType, Element element, String namespace) throws WSDLException {
        JAXWSBinding jaxwsBinding = (JAXWSBinding)this.extReg.createExtension(parentType, ToolConstants.JAXWS_BINDINGS);
        jaxwsBinding.setElementType(ToolConstants.JAXWS_BINDINGS);
        jaxwsBinding.setElement(element);
        jaxwsBinding.setDocumentBaseURI(namespace);
        this.parseElement(jaxwsBinding, element);
        return jaxwsBinding;
    }

    void parseElement(JAXWSBinding jaxwsBinding, Element element) {
        Node child = element.getFirstChild();
        if (child == null) {
            if (this.isAsyncElement(element).booleanValue()) {
                jaxwsBinding.setEnableAsyncMapping(this.getNodeValue(element));
            }
            if (this.isMIMEElement(element).booleanValue()) {
                jaxwsBinding.setEnableMime(this.getNodeValue(element));
            }
            if (this.isPackageElement(element)) {
                jaxwsBinding.setPackage(this.getPackageName(element));
            }
            if (this.isWrapperStyle(element).booleanValue()) {
                jaxwsBinding.setEnableWrapperStyle(this.getNodeValue(element));
            }
        } else {
            while (child != null) {
                Element childElement;
                Node docChild;
                if (this.isAsyncElement(child).booleanValue()) {
                    jaxwsBinding.setEnableAsyncMapping(this.getNodeValue(child));
                } else if (this.isMIMEElement(child).booleanValue()) {
                    jaxwsBinding.setEnableMime(this.getNodeValue(child));
                } else if (this.isWrapperStyle(child).booleanValue()) {
                    jaxwsBinding.setEnableWrapperStyle(this.getNodeValue(child));
                } else if (this.isPackageElement(child)) {
                    jaxwsBinding.setPackage(this.getPackageName(child));
                    docChild = DOMUtils.getChild((Node)child, (int)1);
                    if (docChild != null && this.isJAXWSClassDoc(docChild)) {
                        jaxwsBinding.setPackageJavaDoc(StringEscapeUtils.escapeHtml4((String)DOMUtils.getContent((Node)docChild)));
                    }
                } else if (this.isJAXWSMethodElement(child)) {
                    jaxwsBinding.setMethodName(this.getMethodName(child));
                    docChild = DOMUtils.getChild((Node)child, (int)1);
                    if (docChild != null && this.isJAXWSClassDoc(docChild)) {
                        jaxwsBinding.setMethodJavaDoc(StringEscapeUtils.escapeHtml4((String)DOMUtils.getContent((Node)docChild)));
                    }
                } else if (this.isJAXWSParameterElement(child)) {
                    childElement = (Element)child;
                    String partPath = "//" + childElement.getAttribute("part");
                    Node node = this.queryXPathNode(element.getOwnerDocument().getDocumentElement(), partPath);
                    String messageName = "";
                    String partName = "";
                    if (node != null) {
                        partName = ((Element)node).getAttribute("name");
                        Node messageNode = node.getParentNode();
                        if (messageNode != null) {
                            Element messageEle = (Element)messageNode;
                            messageName = messageEle.getAttribute("name");
                        }
                    }
                    String name = childElement.getAttribute("name");
                    String elementNameString = childElement.getAttribute("childElementName");
                    QName elementName = null;
                    if (!StringUtils.isEmpty((String)elementNameString)) {
                        String ns = "";
                        if (elementNameString.indexOf(58) != -1) {
                            ns = elementNameString.substring(0, elementNameString.indexOf(58));
                            ns = childElement.lookupNamespaceURI(ns);
                            elementNameString = elementNameString.substring(elementNameString.indexOf(58) + 1);
                        }
                        elementName = new QName(ns, elementNameString);
                    }
                    JAXWSParameter jpara = new JAXWSParameter(messageName, partName, elementName, name);
                    jaxwsBinding.addJaxwsPara(jpara);
                } else if (this.isJAXWSClass(child)) {
                    childElement = (Element)child;
                    String clzName = childElement.getAttribute("name");
                    String javadoc = "";
                    Node docChild2 = DOMUtils.getChild((Node)child, (int)1);
                    if (docChild2 != null && this.isJAXWSClassDoc(docChild2)) {
                        javadoc = StringEscapeUtils.escapeHtml4((String)DOMUtils.getContent((Node)docChild2));
                    }
                    JAXWSClass jaxwsClass = new JAXWSClass(clzName, javadoc);
                    jaxwsBinding.setJaxwsClass(jaxwsClass);
                }
                child = child.getNextSibling();
            }
        }
    }

    private boolean isJAXWSMethodElement(Node node) {
        return "http://java.sun.com/xml/ns/jaxws".equals(node.getNamespaceURI()) && "method".equals(node.getLocalName());
    }

    private String getMethodName(Node node) {
        Element ele = (Element)node;
        return ele.getAttribute("name");
    }

    private boolean isPackageElement(Node node) {
        return "http://java.sun.com/xml/ns/jaxws".equals(node.getNamespaceURI()) && "package".equals(node.getLocalName());
    }

    private boolean isJAXWSParameterElement(Node node) {
        return "http://java.sun.com/xml/ns/jaxws".equals(node.getNamespaceURI()) && "parameter".equals(node.getLocalName());
    }

    private boolean isJAXWSClass(Node node) {
        return "http://java.sun.com/xml/ns/jaxws".equals(node.getNamespaceURI()) && "class".equals(node.getLocalName());
    }

    private boolean isJAXWSClassDoc(Node node) {
        return "http://java.sun.com/xml/ns/jaxws".equals(node.getNamespaceURI()) && "javadoc".equals(node.getLocalName());
    }

    private String getPackageName(Node node) {
        Element ele = (Element)node;
        return ele.getAttribute("name");
    }

    private Boolean isAsyncElement(Node node) {
        return "enableAsyncMapping".equals(node.getLocalName()) && "http://java.sun.com/xml/ns/jaxws".equals(node.getNamespaceURI());
    }

    private Boolean isWrapperStyle(Node node) {
        return "enableWrapperStyle".equals(node.getLocalName()) && "http://java.sun.com/xml/ns/jaxws".equals(node.getNamespaceURI());
    }

    private Boolean getNodeValue(Node node) {
        return Boolean.valueOf(node.getTextContent());
    }

    private Boolean isMIMEElement(Node node) {
        return "enableMIMEContent".equals(node.getLocalName()) && "http://java.sun.com/xml/ns/jaxws".equals(node.getNamespaceURI());
    }

    private Node queryXPathNode(Node target, String expression) {
        NodeList nlst;
        try {
            ContextImpl contextImpl = new ContextImpl(target);
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(contextImpl);
            nlst = (NodeList)xpath.evaluate(expression, target, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            Message msg = new Message("XPATH_ERROR", LOG, new Object[]{expression});
            throw new ToolException(msg, (Throwable)e);
        }
        if (nlst.getLength() != 1) {
            Message msg = new Message("ERROR_TARGETNODE_WITH_XPATH", LOG, new Object[]{expression});
            throw new ToolException(msg);
        }
        Node rnode = nlst.item(0);
        if (!(rnode instanceof Element)) {
            return null;
        }
        return rnode;
    }

    static class ContextImpl
    implements NamespaceContext {
        private Node targetNode;

        ContextImpl(Node node) {
            this.targetNode = node;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.targetNode.getOwnerDocument().lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String nsURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }
    }
}

