/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.config;

import java.net.InetAddress;
import java.util.Arrays;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestConfig {
    @Test
    public void testBasics() {
        RequestConfig config = RequestConfig.custom().build();
        config.toString();
    }

    @Test
    public void testDefaults() {
        RequestConfig config = RequestConfig.DEFAULT;
        Assert.assertEquals((long)-1L, (long)config.getSocketTimeout());
        Assert.assertEquals((long)-1L, (long)config.getConnectTimeout());
        Assert.assertEquals((long)-1L, (long)config.getConnectionRequestTimeout());
        Assert.assertEquals((Object)false, (Object)config.isExpectContinueEnabled());
        Assert.assertEquals((Object)true, (Object)config.isAuthenticationEnabled());
        Assert.assertEquals((Object)true, (Object)config.isRedirectsEnabled());
        Assert.assertEquals((Object)true, (Object)config.isRelativeRedirectsAllowed());
        Assert.assertEquals((Object)false, (Object)config.isCircularRedirectsAllowed());
        Assert.assertEquals((long)50L, (long)config.getMaxRedirects());
        Assert.assertEquals(null, (Object)config.getCookieSpec());
        Assert.assertEquals(null, (Object)config.getLocalAddress());
        Assert.assertEquals(null, (Object)config.getProxy());
        Assert.assertEquals(null, (Object)config.getTargetPreferredAuthSchemes());
        Assert.assertEquals(null, (Object)config.getProxyPreferredAuthSchemes());
        Assert.assertEquals((Object)true, (Object)config.isContentCompressionEnabled());
    }

    @Test
    public void testBuildAndCopy() throws Exception {
        RequestConfig config0 = RequestConfig.custom().setSocketTimeout(22).setConnectTimeout(33).setConnectionRequestTimeout(44).setExpectContinueEnabled(true).setAuthenticationEnabled(false).setRedirectsEnabled(false).setRelativeRedirectsAllowed(false).setCircularRedirectsAllowed(true).setMaxRedirects(100).setCookieSpec("standard").setLocalAddress(InetAddress.getLocalHost()).setProxy(new HttpHost("someproxy")).setTargetPreferredAuthSchemes(Arrays.asList("NTLM")).setProxyPreferredAuthSchemes(Arrays.asList("Digest")).setContentCompressionEnabled(false).build();
        RequestConfig config = RequestConfig.copy((RequestConfig)config0).build();
        Assert.assertEquals((long)22L, (long)config.getSocketTimeout());
        Assert.assertEquals((long)33L, (long)config.getConnectTimeout());
        Assert.assertEquals((long)44L, (long)config.getConnectionRequestTimeout());
        Assert.assertEquals((Object)true, (Object)config.isExpectContinueEnabled());
        Assert.assertEquals((Object)false, (Object)config.isAuthenticationEnabled());
        Assert.assertEquals((Object)false, (Object)config.isRedirectsEnabled());
        Assert.assertEquals((Object)false, (Object)config.isRelativeRedirectsAllowed());
        Assert.assertEquals((Object)true, (Object)config.isCircularRedirectsAllowed());
        Assert.assertEquals((long)100L, (long)config.getMaxRedirects());
        Assert.assertEquals((Object)"standard", (Object)config.getCookieSpec());
        Assert.assertEquals((Object)InetAddress.getLocalHost(), (Object)config.getLocalAddress());
        Assert.assertEquals((Object)new HttpHost("someproxy"), (Object)config.getProxy());
        Assert.assertEquals(Arrays.asList("NTLM"), (Object)config.getTargetPreferredAuthSchemes());
        Assert.assertEquals(Arrays.asList("Digest"), (Object)config.getProxyPreferredAuthSchemes());
        Assert.assertEquals((Object)false, (Object)config.isContentCompressionEnabled());
    }
}

