/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Test;

public class TestURIBuilder {
    @Test
    public void testHierarchicalUri() throws Exception {
        URI uri = new URI("http", "stuff", "localhost", 80, "/some stuff", "param=stuff", "fragment");
        URIBuilder uribuilder = new URIBuilder(uri);
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://stuff@localhost:80/some%20stuff?param=stuff#fragment"), (Object)result);
    }

    @Test
    public void testMutationToRelativeUri() throws Exception {
        URI uri = new URI("http://stuff@localhost:80/stuff?param=stuff#fragment");
        URIBuilder uribuilder = new URIBuilder(uri).setHost(null);
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http:///stuff?param=stuff#fragment"), (Object)result);
    }

    @Test
    public void testMutationRemoveFragment() throws Exception {
        URI uri = new URI("http://stuff@localhost:80/stuff?param=stuff#fragment");
        URI result = new URIBuilder(uri).setFragment(null).build();
        Assert.assertEquals((Object)new URI("http://stuff@localhost:80/stuff?param=stuff"), (Object)result);
    }

    @Test
    public void testMutationRemoveUserInfo() throws Exception {
        URI uri = new URI("http://stuff@localhost:80/stuff?param=stuff#fragment");
        URI result = new URIBuilder(uri).setUserInfo(null).build();
        Assert.assertEquals((Object)new URI("http://localhost:80/stuff?param=stuff#fragment"), (Object)result);
    }

    @Test
    public void testMutationRemovePort() throws Exception {
        URI uri = new URI("http://stuff@localhost:80/stuff?param=stuff#fragment");
        URI result = new URIBuilder(uri).setPort(-1).build();
        Assert.assertEquals((Object)new URI("http://stuff@localhost/stuff?param=stuff#fragment"), (Object)result);
    }

    @Test
    public void testOpaqueUri() throws Exception {
        URI uri = new URI("stuff", "some-stuff", "fragment");
        URIBuilder uribuilder = new URIBuilder(uri);
        URI result = uribuilder.build();
        Assert.assertEquals((Object)uri, (Object)result);
    }

    @Test
    public void testOpaqueUriMutation() throws Exception {
        URI uri = new URI("stuff", "some-stuff", "fragment");
        URIBuilder uribuilder = new URIBuilder(uri).setCustomQuery("param1&param2=stuff").setFragment(null);
        Assert.assertEquals((Object)new URI("stuff:?param1&param2=stuff"), (Object)uribuilder.build());
    }

    @Test
    public void testHierarchicalUriMutation() throws Exception {
        URIBuilder uribuilder = new URIBuilder("/").setScheme("http").setHost("localhost").setPort(80).setPath("/stuff");
        Assert.assertEquals((Object)new URI("http://localhost:80/stuff"), (Object)uribuilder.build());
    }

    @Test
    public void testEmpty() throws Exception {
        URIBuilder uribuilder = new URIBuilder();
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI(""), (Object)result);
    }

    @Test
    public void testSetUserInfo() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff", null);
        URIBuilder uribuilder = new URIBuilder(uri).setUserInfo("user", "password");
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://user:password@localhost:80/?param=stuff"), (Object)result);
    }

    @Test
    public void testRemoveParameters() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff", null);
        URIBuilder uribuilder = new URIBuilder(uri).removeQuery();
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://localhost:80/"), (Object)result);
    }

    @Test
    public void testSetParameter() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff&blah&blah", null);
        URIBuilder uribuilder = new URIBuilder(uri).setParameter("param", "some other stuff").setParameter("blah", "blah");
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://localhost:80/?param=some+other+stuff&blah=blah"), (Object)result);
    }

    @Test
    public void testSetParametersWithEmptyArg() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/test", "param=test", null);
        URIBuilder uribuilder = new URIBuilder(uri).setParameters(new NameValuePair[0]);
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://localhost:80/test"), (Object)result);
    }

    @Test
    public void testSetParametersWithEmptyList() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/test", "param=test", null);
        URIBuilder uribuilder = new URIBuilder(uri).setParameters(Arrays.asList(new NameValuePair[0]));
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://localhost:80/test"), (Object)result);
    }

    @Test
    public void testParameterWithSpecialChar() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff", null);
        URIBuilder uribuilder = new URIBuilder(uri).addParameter("param", "1 + 1 = 2").addParameter("param", "blah&blah");
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://localhost:80/?param=stuff&param=1+%2B+1+%3D+2&param=blah%26blah"), (Object)result);
    }

    @Test
    public void testAddParameter() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff&blah&blah", null);
        URIBuilder uribuilder = new URIBuilder(uri).addParameter("param", "some other stuff").addParameter("blah", "blah");
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://localhost:80/?param=stuff&blah&blah&param=some+other+stuff&blah=blah"), (Object)result);
    }

    @Test
    public void testQueryEncoding() throws Exception {
        URI uri1 = new URI("https://somehost.com/stuff?client_id=1234567890&redirect_uri=https%3A%2F%2Fsomehost.com%2Fblah+blah%2F");
        URI uri2 = new URIBuilder("https://somehost.com/stuff").addParameter("client_id", "1234567890").addParameter("redirect_uri", "https://somehost.com/blah blah/").build();
        Assert.assertEquals((Object)uri1, (Object)uri2);
    }

    @Test
    public void testQueryAndParameterEncoding() throws Exception {
        URI uri1 = new URI("https://somehost.com/stuff?param1=12345&param2=67890");
        URI uri2 = new URIBuilder("https://somehost.com/stuff").setCustomQuery("this&that").addParameter("param1", "12345").addParameter("param2", "67890").build();
        Assert.assertEquals((Object)uri1, (Object)uri2);
    }

    @Test
    public void testPathEncoding() throws Exception {
        URI uri1 = new URI("https://somehost.com/some%20path%20with%20blanks/");
        URI uri2 = new URIBuilder().setScheme("https").setHost("somehost.com").setPath("/some path with blanks/").build();
        Assert.assertEquals((Object)uri1, (Object)uri2);
    }

    @Test
    public void testAgainstURI() throws Exception {
        String scheme = "https";
        String host = "localhost";
        String specials = "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz";
        URI uri = new URI("https", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", "localhost", 80, "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz", "/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz");
        URI bld = new URIBuilder().setScheme("https").setHost("localhost").setUserInfo("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setPath("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setCustomQuery("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").setFragment("/abcd!$&*()_-+.,=:;'~@[]?<>|#^%\"{}\\\u00a3`\u00ac\u00a6xyz").build();
        Assert.assertEquals((Object)uri.getHost(), (Object)bld.getHost());
        Assert.assertEquals((Object)uri.getUserInfo(), (Object)bld.getUserInfo());
        Assert.assertEquals((Object)uri.getPath(), (Object)bld.getPath());
        Assert.assertEquals((Object)uri.getQuery(), (Object)bld.getQuery());
        Assert.assertEquals((Object)uri.getFragment(), (Object)bld.getFragment());
    }

    @Test
    public void testAgainstURIEncoded() throws Exception {
        String scheme = "https";
        String host = "localhost";
        String specials = "/ abcd!$&*()_-+.,=:;'~<>/@[]|#^%\"{}\\`xyz";
        URI uri = new URI("https", "/ abcd!$&*()_-+.,=:;'~<>/@[]|#^%\"{}\\`xyz", "localhost", 80, "/ abcd!$&*()_-+.,=:;'~<>/@[]|#^%\"{}\\`xyz", "/ abcd!$&*()_-+.,=:;'~<>/@[]|#^%\"{}\\`xyz", "/ abcd!$&*()_-+.,=:;'~<>/@[]|#^%\"{}\\`xyz");
        URI bld = new URIBuilder().setScheme("https").setHost("localhost").setUserInfo("/ abcd!$&*()_-+.,=:;'~<>/@[]|#^%\"{}\\`xyz").setPath("/ abcd!$&*()_-+.,=:;'~<>/@[]|#^%\"{}\\`xyz").setCustomQuery("/ abcd!$&*()_-+.,=:;'~<>/@[]|#^%\"{}\\`xyz").setFragment("/ abcd!$&*()_-+.,=:;'~<>/@[]|#^%\"{}\\`xyz").build();
        Assert.assertEquals((Object)uri.getHost(), (Object)bld.getHost());
        Assert.assertEquals((Object)uri.getRawUserInfo(), (Object)bld.getRawUserInfo());
        Assert.assertEquals((Object)uri.getRawPath(), (Object)bld.getRawPath());
        Assert.assertEquals((Object)uri.getRawQuery(), (Object)bld.getRawQuery());
        Assert.assertEquals((Object)uri.getRawFragment(), (Object)bld.getRawFragment());
    }

    @Test
    public void testBuildAddParametersUTF8() throws Exception {
        this.assertAddParameters(Consts.UTF_8);
    }

    @Test
    public void testBuildAddParametersISO88591() throws Exception {
        this.assertAddParameters(Consts.ISO_8859_1);
    }

    public void assertAddParameters(Charset charset) throws Exception {
        URI uri = new URIBuilder("https://somehost.com/stuff").setCharset(charset).addParameters(this.createParameters()).build();
        this.assertBuild(charset, uri);
    }

    @Test
    public void testBuildSetParametersUTF8() throws Exception {
        this.assertSetParameters(Consts.UTF_8);
    }

    @Test
    public void testBuildSetParametersISO88591() throws Exception {
        this.assertSetParameters(Consts.ISO_8859_1);
    }

    public void assertSetParameters(Charset charset) throws Exception {
        URI uri = new URIBuilder("https://somehost.com/stuff").setCharset(charset).setParameters(this.createParameters()).build();
        this.assertBuild(charset, uri);
    }

    public void assertBuild(Charset charset, URI uri) throws Exception {
        String encodedData1 = URLEncoder.encode("\"1\u00aa position\"", charset.displayName());
        String encodedData2 = URLEncoder.encode("Jos\u00e9 Abra\u00e3o", charset.displayName());
        String uriExpected = String.format("https://somehost.com/stuff?parameter1=value1&parameter2=%s&parameter3=%s", encodedData1, encodedData2);
        Assert.assertEquals((Object)uriExpected, (Object)uri.toString());
    }

    private List<NameValuePair> createParameters() {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("parameter1", "value1"));
        parameters.add((NameValuePair)new BasicNameValuePair("parameter2", "\"1\u00aa position\""));
        parameters.add((NameValuePair)new BasicNameValuePair("parameter3", "Jos\u00e9 Abra\u00e3o"));
        return parameters;
    }

    @Test
    public void testMalformedPath() throws Exception {
        String path = "@notexample.com/mypath";
        URI uri = new URIBuilder("@notexample.com/mypath").setHost("example.com").build();
        Assert.assertEquals((Object)"example.com", (Object)uri.getHost());
    }

    @Test
    public void testRelativePath() throws Exception {
        URI uri = new URIBuilder("./mypath").build();
        Assert.assertEquals((Object)new URI("./mypath"), (Object)uri);
    }

    @Test
    public void testRelativePathWithAuthority() throws Exception {
        URI uri = new URIBuilder("./mypath").setHost("somehost").setScheme("http").build();
        Assert.assertEquals((Object)new URI("http://somehost/./mypath"), (Object)uri);
    }
}

