/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestRFC2617Scheme {
    @Test
    public void testProcessChallenge() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        BasicHeader header = new BasicHeader("WWW-Authenticate", "Test realm=\"realm1\", test, test1 =  stuff, test2 =  \"stuff, stuff\", test3=\"crap");
        authscheme.processChallenge((Header)header);
        Assert.assertEquals((Object)"test", (Object)authscheme.getSchemeName());
        Assert.assertEquals((Object)"TEST", (Object)authscheme.toString());
        Assert.assertEquals((Object)"realm1", (Object)authscheme.getParameter("realm"));
        Assert.assertEquals(null, (Object)authscheme.getParameter("test"));
        Assert.assertEquals((Object)"stuff", (Object)authscheme.getParameter("test1"));
        Assert.assertEquals((Object)"stuff, stuff", (Object)authscheme.getParameter("test2"));
        Assert.assertEquals((Object)"crap", (Object)authscheme.getParameter("test3"));
        Assert.assertEquals(null, (Object)authscheme.getParameter(null));
    }

    @Test
    public void testProcessChallengeWithLotsOfBlanks() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        buffer.append(" WWW-Authenticate:    Test       realm=\"realm1\"");
        BufferedHeader header = new BufferedHeader(buffer);
        authscheme.processChallenge((Header)header);
        Assert.assertEquals((Object)"test", (Object)authscheme.getSchemeName());
        Assert.assertEquals((Object)"realm1", (Object)authscheme.getParameter("realm"));
    }

    @Test
    public void testNullHeader() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        try {
            authscheme.processChallenge(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=MalformedChallengeException.class)
    public void testInvalidHeader() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        BasicHeader header = new BasicHeader("whatever", "Test realm=\"realm1\"");
        authscheme.processChallenge((Header)header);
    }

    @Test(expected=MalformedChallengeException.class)
    public void testInvalidSchemeName() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        BasicHeader header = new BasicHeader("WWW-Authenticate", "Not-a-Test realm=\"realm1\"");
        authscheme.processChallenge((Header)header);
    }

    @Test(expected=MalformedChallengeException.class)
    public void testInvalidHeaderValue() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        BasicHeader header = new BasicHeader("whatever", "whatever");
        authscheme.processChallenge((Header)header);
    }

    @Test
    public void testSerialization() throws Exception {
        BasicHeader challenge = new BasicHeader("WWW-Authenticate", "test realm=\"test\", blah=blah, yada=\"yada yada\"");
        TestAuthScheme testScheme = new TestAuthScheme(Consts.ISO_8859_1);
        testScheme.processChallenge((Header)challenge);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject((Object)testScheme);
        out.flush();
        byte[] raw = buffer.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(raw));
        TestAuthScheme authScheme = (TestAuthScheme)((Object)in.readObject());
        Assert.assertEquals((Object)Consts.ISO_8859_1, (Object)authScheme.getCredentialsCharset());
        Assert.assertEquals((Object)"test", (Object)authScheme.getParameter("realm"));
        Assert.assertEquals((Object)"blah", (Object)authScheme.getParameter("blah"));
        Assert.assertEquals((Object)"yada yada", (Object)authScheme.getParameter("yada"));
    }

    static class TestAuthScheme
    extends RFC2617Scheme {
        private static final long serialVersionUID = 1L;

        public TestAuthScheme() {
        }

        public TestAuthScheme(Charset charset) {
            super(charset);
        }

        @Deprecated
        public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
            return null;
        }

        public String getSchemeName() {
            return "test";
        }

        public boolean isComplete() {
            return false;
        }

        public boolean isConnectionBased() {
            return false;
        }
    }
}

